% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branching.R
\name{gen_orglinearbranches}
\alias{gen_orglinearbranches}
\title{Generate data with linear shaped branches in a initial point}
\usage{
gen_orglinearbranches(n = 400, p = 4, k = 4, allow_share = TRUE)
}
\arguments{
\item{n}{A numeric value (default: 400) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{k}{A numeric value (default: 4) representing the number of branches.}

\item{allow_share}{A logical value (default: TRUE).
If TRUE, multiple branches may share the same 2D subspace.
If FALSE, branches are sampled without replacement from all possible 2D
subspaces until exhausted.}
}
\value{
A data containing linear shaped branches originated in one point.
}
\description{
This function generates a dataset representing a structure with linear shaped branches.
}
\examples{
set.seed(20240412)
orglinearbranches <- gen_orglinearbranches(n = 400, p = 4, k = 4)
}
