% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_car_anova.R
\name{ard_car_anova}
\alias{ard_car_anova}
\title{ARD ANOVA from car Package}
\usage{
ard_car_anova(x, ...)
}
\arguments{
\item{x}{regression model object}

\item{...}{arguments passed to \code{car::Anova(...)}}
}
\value{
data frame
}
\description{
Function takes a regression model object and calculated ANOVA using \code{\link[car:Anova]{car::Anova()}}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("broom.helpers", "car", "parameters")))) withAutoprint(\{ # examplesIf}
lm(AGE ~ ARM, data = cards::ADSL) |>
  ard_car_anova()

glm(vs ~ factor(cyl) + factor(am), data = mtcars, family = binomial) |>
  ard_car_anova(test.statistic = "Wald")
\dontshow{\}) # examplesIf}
}
