% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_t_test_onesample.R
\name{ard_stats_t_test_onesample}
\alias{ard_stats_t_test_onesample}
\title{ARD one-sample t-test}
\usage{
ard_stats_t_test_onesample(
  data,
  variables,
  by = dplyr::group_vars(data),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame. See below for details.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be analyzed. Independent t-tests will be computed for
each variable.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
optional column name to stratify results by.}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}

\item{...}{arguments passed to \code{t.test()}}
}
\value{
ARD data frame
}
\description{
Analysis results data for one-sample t-tests.
Result may be stratified by including the \code{by} argument.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) withAutoprint(\{ # examplesIf}
cards::ADSL |>
  ard_stats_t_test_onesample(by = ARM, variables = AGE)
\dontshow{\}) # examplesIf}
}
