% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_repair_relevance.r
\name{check_repair_relevance_pred}
\alias{check_repair_relevance_pred}
\title{Check for inconsistent relevance values}
\usage{
check_repair_relevance_pred(
  predicted,
  ignore_inconsistencies = options::opt("ignore_inconsistencies")
)
}
\arguments{
\item{predicted}{Multi-label prediction results. Expects a data.frame with
columns \code{"label_id", "doc_id", "relevance"}.}

\item{ignore_inconsistencies}{Warnings about data inconsistencies will be silenced. (Defaults to \code{FALSE}, overwritable using option 'casimir.ignore_inconsistencies' or environment variable 'R_CASIMIR_IGNORE_INCONSISTENCIES')}
}
\value{
A valid \code{predicted} data.frame with possibly eliminated missing
values.
}
\description{
Internal helper function to check a data.frame with predicted labels for a
valid relevance column.
}
