% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{subgraph}
\alias{subgraph}
\title{Get the induced subgraph}
\usage{
subgraph(cg, nodes = NULL, index = NULL)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{nodes}{A vector of node names, a vector of unquoted
node names, or an expression combining these with \code{+} and \code{c()}.}

\item{index}{A vector of node indexes.}
}
\value{
A new \code{caugi} that is a subgraph of the selected nodes.
}
\description{
Get the induced subgraph
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)
sub_cg <- subgraph(cg, c("B", "C"))
cg2 <- caugi(B \%-->\% C, class = "DAG")
all(nodes(sub_cg) == nodes(cg2)) # TRUE
all(edges(sub_cg) == edges(cg2)) # TRUE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()}
}
\concept{queries}
