% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{add-caugi_plot-caugi_plot}
\alias{add-caugi_plot-caugi_plot}
\alias{pipe-caugi_plot-caugi_plot}
\title{Compose Plots Horizontally}
\arguments{
\item{e1}{A \code{caugi_plot} object (left plot)}

\item{e2}{A \code{caugi_plot} object (right plot)}
}
\value{
A \code{caugi_plot} object containing the composed layout
}
\description{
Arrange two plots side-by-side with configurable spacing. The \code{+} and \code{|}
operators are equivalent and can be used interchangeably. Compositions can
be nested to create complex multi-plot layouts.
}
\details{
The spacing between plots is controlled by the global option
\code{caugi_options()$plot$spacing}, which defaults to \code{grid::unit(1, "lines")}.
Compositions can be nested arbitrarily:
\itemize{
\item \code{p1 + p2} - two plots side-by-side
\item \code{(p1 + p2) + p3} - three plots in a row
\item \code{(p1 + p2) / p3} - two plots on top, one below
}
}
\examples{
cg1 <- caugi(A \%-->\% B, B \%-->\% C)
cg2 <- caugi(X \%-->\% Y, Y \%-->\% Z)

p1 <- plot(cg1, main = "Graph 1")
p2 <- plot(cg2, main = "Graph 2")

# Horizontal composition
p1 + p2
p1 | p2 # equivalent

# Adjust spacing
caugi_options(plot = list(spacing = grid::unit(2, "lines")))
p1 + p2

}
\seealso{
\code{\link[=caugi_options]{caugi_options()}} for configuring spacing and default styles

Other plotting: 
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_bipartite}()},
\code{\link{caugi_layout_fruchterman_reingold}()},
\code{\link{caugi_layout_kamada_kawai}()},
\code{\link{caugi_layout_sugiyama}()},
\code{\link{caugi_layout_tiered}()},
\code{\link{caugi_plot}()},
\code{\link{divide-caugi_plot-caugi_plot}},
\code{\link{plot}()}
}
\concept{plotting}
