% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment.R
\name{all_adjustment_sets_admg}
\alias{all_adjustment_sets_admg}
\title{Get all valid adjustment sets in an ADMG}
\usage{
all_adjustment_sets_admg(
  cg,
  X = NULL,
  Y = NULL,
  X_index = NULL,
  Y_index = NULL,
  minimal = TRUE,
  max_size = 3L
)
}
\arguments{
\item{cg}{A \code{caugi} object of class ADMG.}

\item{X, Y}{Node names (can be vectors for multiple treatments/outcomes).}

\item{X_index, Y_index}{Optional 1-based indices.}

\item{minimal}{Logical; if \code{TRUE} (default), only minimal sets are returned.}

\item{max_size}{Integer; maximum size of sets to consider (default 3).}
}
\value{
A list of character vectors, each a valid adjustment set
(possibly empty list if none exist).
}
\description{
Enumerates all valid adjustment sets for estimating the causal
effect of \code{X} on \code{Y} in an ADMG, up to a specified maximum size.
}
\examples{
cg <- caugi(
  L \%-->\% X,
  X \%-->\% Y,
  L \%-->\% Y,
  M \%-->\% Y,
  class = "ADMG"
)

all_adjustment_sets_admg(cg, X = "X", Y = "Y", minimal = TRUE)
# Returns {L} as minimal adjustment set

}
\seealso{
Other adjustment: 
\code{\link{adjustment_set}()},
\code{\link{all_backdoor_sets}()},
\code{\link{d_separated}()},
\code{\link{is_valid_adjustment_admg}()},
\code{\link{is_valid_backdoor}()}
}
\concept{adjustment}
