% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{caugi_layout_bipartite}
\alias{caugi_layout_bipartite}
\title{Bipartite Graph Layout}
\usage{
caugi_layout_bipartite(x, partition = NULL, orientation = c("columns", "rows"))
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{partition}{Optional logical vector indicating node partitions.
Nodes with \code{TRUE} are placed in one partition and nodes with \code{FALSE}
in the other. Length must equal the number of nodes. Both partitions
must be non-empty. If \code{NULL} (default), attempts to detect bipartite
structure automatically by assigning nodes without incoming edges to
one partition and others to the second partition.}

\item{orientation}{Character string specifying the layout orientation:
\itemize{
\item \code{"columns"}: Two vertical columns. First partition on right (x=1),
second partition on left (x=0).
\item \code{"rows"}: Two horizontal rows. First partition on top (y=1),
second partition on bottom (y=0).
}}
}
\value{
A \code{data.frame} with columns \code{name}, \code{x}, and \code{y} containing node
names and their coordinates.
}
\description{
Computes node coordinates for bipartite graphs, placing nodes in two
parallel lines (rows or columns) based on a partition. If the graph
has not been built yet, it will be built automatically before computing
the layout.
}
\examples{
# Create a bipartite graph (causes -> effects)
cg <- caugi(A \%-->\% X, A \%-->\% Y, B \%-->\% X, B \%-->\% Y)
partition <- c(TRUE, TRUE, FALSE, FALSE) # A, B = causes, X, Y = effects

# Two horizontal rows (causes on top)
layout_rows <- caugi_layout_bipartite(cg, partition, orientation = "rows")

# Two vertical columns (causes on right)
layout_cols <- caugi_layout_bipartite(cg, partition, orientation = "columns")

}
\seealso{
Other plotting: 
\code{\link{add-caugi_plot-caugi_plot}},
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_fruchterman_reingold}()},
\code{\link{caugi_layout_kamada_kawai}()},
\code{\link{caugi_layout_sugiyama}()},
\code{\link{caugi_layout_tiered}()},
\code{\link{caugi_plot}()},
\code{\link{divide-caugi_plot-caugi_plot}},
\code{\link{plot}()}
}
\concept{plotting}
