% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_admg}
\alias{is_admg}
\title{Is the \code{caugi} graph an ADMG?}
\usage{
is_admg(cg, force_check = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{force_check}{Logical; if \code{TRUE}, the function will test if the graph is
an ADMG, if \code{FALSE} (default), it will look at the graph class and match
it, if possible.}
}
\value{
A logical value indicating whether the graph is an ADMG.
}
\description{
Checks if the given \code{caugi} graph is an
Acyclic Directed Mixed Graph (ADMG).

An ADMG contains only directed (\verb{-->}) and bidirected (\verb{<->}) edges,
and the directed part must be acyclic.
}
\examples{
cg_admg <- caugi(
  A \%-->\% B,
  A \%<->\% C,
  class = "ADMG"
)
is_admg(cg_admg) # TRUE

cg_dag <- caugi(
  A \%-->\% B,
  class = "DAG"
)
is_admg(cg_dag) # TRUE (DAGs are valid ADMGs)

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
