% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-mermaid.R
\name{to_mermaid}
\alias{to_mermaid}
\title{Export caugi Graph to Mermaid Format}
\usage{
to_mermaid(x, direction = "TD")
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{direction}{Graph direction: "TB" (top-bottom), "TD" (top-down),
"BT" (bottom-top), "LR" (left-right), or "RL" (right-left).
Default is "TD".}
}
\value{
A \code{caugi_mermaid} object containing the Mermaid representation.
}
\description{
Converts a caugi graph to the Mermaid flowchart format as a string.
Mermaid diagrams can be rendered in Quarto, R Markdown, GitHub, and
many other platforms.
}
\details{
The function handles different edge types:
\itemize{
\item Directed edges (\verb{-->}) use \verb{-->} in Mermaid
\item Undirected edges (\verb{---}) use \verb{---} in Mermaid
\item Bidirected edges (\verb{<->}) use \verb{<-->} in Mermaid
\item Partial edges (\verb{o->}) use \verb{o-->} in Mermaid (circle end)
}

Node names are automatically escaped if they contain special characters.
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  C \%-->\% D,
  class = "DAG"
)

# Get Mermaid string
mmd <- to_mermaid(cg)
mmd@content

# With custom direction
mmd <- to_mermaid(cg, direction = "LR")

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
