% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_xifti.R
\name{convert_xifti}
\alias{convert_xifti}
\alias{convert_to_dlabel}
\alias{convert_to_dscalar}
\alias{convert_to_dtseries}
\title{Convert \code{"xifti"}}
\usage{
convert_xifti(
  x,
  to = c("dscalar", "dtseries", "dlabel"),
  cifti_target_fname = NULL,
  ...
)

convert_to_dlabel(
  x,
  cifti_target_fname = NULL,
  levels_old = NULL,
  levels = NULL,
  labels = NULL,
  nsig = Inf,
  colors = "Set2",
  add_white = TRUE,
  return_conversion_table = FALSE
)

convert_to_dscalar(x, cifti_target_fname = NULL, names = NULL)

convert_to_dtseries(
  x,
  cifti_target_fname = NULL,
  time_start = 0,
  time_step = 1,
  time_unit = c("second", "hertz", "meter", "radian")
)
}
\arguments{
\item{x}{The CIFTI file name or \code{"xifti"} object to convert.}

\item{to}{The desired intent: \code{"dscalar"} (default), \code{"dtseries"},
or \code{"dlabel"}}

\item{cifti_target_fname}{File name for the converted CIFTI. Only used if
\code{x} is a CIFTI file name. If \code{NULL} (default), will use the same
name as \code{x} but with the extension updated.}

\item{...}{Only used if \code{x} is a \code{"xifti"} object. Additional
options specific to the target type and intent, e.g. for
\code{convert_to_dlabel}.}

\item{levels_old, levels, labels}{(Optional) \code{levels_old} is a vector of
the original data values. They should all be unique. They may not all occur
in the \code{"xifti"} data, but every datapoint in the \code{"xifti"} must
occur in \code{levels_old}. If \code{levels_old} is not provided it will be set to
the vector of all unique values in the data, in ascending order.

If \code{levels} is not provided, the original values will be re-mapped
to integers from $0$ to $N-1$ (the "Keys" of a "dlabel" CIFTI), with $N$
being the length of \code{levels_old}. Otherwise, \code{levels} can be a
vector the same length as \code{levels_old} specifying the corresponding new
integers to use (rather than $0$ to $N-1$). If \code{x} is already "dlabel",
then by setting \code{levels_old} to the current label table values and
\code{levels} to the desired new values, the data can be re-leveled
(see examples in function documentation). Note that duplicates in
\code{levels_old} are allowed, to map multiple existing levels to the same
new level.

New label names can be set with \code{labels}. If provided, it must be a
character vector with the same length as \code{levels}. If there are
duplicates in \code{levels}, the first label for a given level will be used.
If \code{labels} is not provided and if \code{x} is already "dlabel", old
labels will be used if they are the same for each column; otherwise, if
the new label names will be set to \code{levels} if it was provided, and
\code{levels_old} if it was not.

Note: \code{NA} and \code{NaN} values are handled a bit differently. Data
locations that are \code{NA} or \code{NaN} will remain unchanged. \code{NA}
and \code{NaN} should not be included in \code{levels_old} or \code{levels}.}

\item{nsig}{Take this many significant digits for the data values. If
\code{Inf} (default), do not round.}

\item{colors}{(Optional) "ROY_BIG_BL", the name of a ColorBrewer palette
(see \code{RColorBrewer::brewer.pal.info} and colorbrewer2.org), the name of
a viridisLite palette, or a character vector of colors. Default:
\code{"Set2"}.}

\item{add_white}{Append white to the beginning of the colors? Default: \code{TRUE}.}

\item{return_conversion_table}{Return the conversion table along with the
converted \code{"xifti"}? Default: \code{FALSE}. It will give the original
\code{values}, the \code{values_new} (i.e. the "Keys"), and the new
\code{label} names.}

\item{names}{The column names. If \code{NULL} (default) and \code{x} does not
already have names, the names will be set to "Column 1", "Column 2", ... .}

\item{time_start, time_step, time_unit}{(Optional) metadata for the new dtseries}
}
\value{
If \code{x} is a CIFTI, the target is a \code{"dlabel"} and
\code{return_conversion_table}, a length-2 list with the first entry being
the ".dlabel" \code{"xifti"} and the second being the conversion table.
Otherwise, the \code{"xifti"} or the output CIFTI file name is directly
returned.
}
\description{
Convert the intent of a CIFTI file or \code{"xifti"} object
}
\examples{
\dontrun{
# Example: change label names
levels_old <- xii$meta$cifti$labels[[1]]$Key
newLabels <- paste0("New Label #", seq(length(levels_old)))
xii <- convert_to_dlabel(xii, levels_old=levels_old, levels=levels_old, labels=newLabels)
# Example: add an empty level
levels_old <- xii$meta$cifti$labels[[1]]$Key
levels_old <- c(levels_old, max(levels_old)+1)
labels <- c(rownames(xii$meta$cifti$labels[[1]]), "Empty")
xii <- convert_to_dlabel(xii, levels_old=levels_old, levels=levels_old, labels=labels)
# Example: set all but the lowest value to the same value & re-label
levels_old <- xii$meta$cifti$labels[[1]]$Key
levels <- ifelse(levels_old==min(levels_old), min(levels_old), min(levels_old)+1)
labels <- ifelse(levels_old==min(levels_old), "Minimum", "Not minimum")
xii <- convert_to_dlabel(xii, levels_old=levels_old, levels=levels, labels=labels)
}

}
\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{impute_xifti}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{move_to_submask}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
