% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet-daily.R
\name{aemet_daily_clim}
\alias{aemet_daily_clim}
\alias{aemet_daily}
\alias{aemet_daily_period}
\alias{aemet_daily_period_all}
\title{Daily/annual climatology values}
\usage{
aemet_daily_clim(
  station = "all",
  start = Sys.Date() - 7,
  end = Sys.Date(),
  verbose = FALSE,
  return_sf = FALSE,
  extract_metadata = FALSE,
  progress = TRUE
)

aemet_daily_period(
  station,
  start = as.integer(format(Sys.Date(), "\%Y")),
  end = start,
  verbose = FALSE,
  return_sf = FALSE,
  extract_metadata = FALSE,
  progress = TRUE
)

aemet_daily_period_all(
  start = as.integer(format(Sys.Date(), "\%Y")),
  end = start,
  verbose = FALSE,
  return_sf = FALSE,
  extract_metadata = FALSE,
  progress = TRUE
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}}) or "all" for all the stations.}

\item{start, end}{Character string with start and end date. See \strong{Details}.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{\link[sf:sf]{sf}} spatial object? If \code{FALSE}
(the default value) it returns a \code{\link[tibble:tibble]{tibble}}. Note that
you need to have the \CRANpkg{sf} package installed.}

\item{extract_metadata}{Logical \code{TRUE/FALSE}. On \code{TRUE} the output is
a \code{\link[tibble:tibble]{tibble}} with the description of the fields. See also
\code{\link[=get_metadata_aemet]{get_metadata_aemet()}}.}

\item{progress}{Logical, display a \code{\link[cli:cli_progress_bar]{cli::cli_progress_bar()}} object. If
\code{verbose = TRUE} won't be displayed.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} or a \CRANpkg{sf} object.
}
\description{
Get climatology values for a station or for all the available stations.
Note that \code{aemet_daily_period()} and \code{aemet_daily_period_all()} are shortcuts
of \code{aemet_daily_clim()}.
}
\details{
\code{start} and \code{end} parameters should be:
\itemize{
\item For \code{aemet_daily_clim()}: A \code{Date} object or a string with format:
\code{YYYY-MM-DD} (\code{"2020-12-31"}) coercible with \code{\link[=as.Date]{as.Date()}}.
\item For \code{aemet_daily_period()} and \code{aemet_daily_period_all()}: A string
representing the year(s) to be extracted: \code{"2020"}, \code{"2018"}.
}
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) withAutoprint(\{ # examplesIf}

library(tibble)
obs <- aemet_daily_clim(c("9434", "3195"))
glimpse(obs)

# Metadata
meta <- aemet_daily_clim(c("9434", "3195"), extract_metadata = TRUE)

glimpse(meta$campos)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=aemet_api_key]{aemet_api_key()}}, \code{\link[=as.Date]{as.Date()}}

Other aemet_api_data: 
\code{\link{aemet_alert_zones}()},
\code{\link{aemet_alerts}()},
\code{\link{aemet_beaches}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_forecast_beaches}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_forecast_fires}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
