% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{unmake_names}
\alias{unmake_names}
\title{Unmake names}
\usage{
unmake_names(x, ori_names)
}
\arguments{
\item{x}{A vector of names generated by \code{base::make.names()}.}

\item{ori_names}{A vector of original names.}
}
\value{
A vector of original names.
}
\description{
Inverse function of \code{make.names}. You can use \code{make.names} to make colnames legal for
subsequent processing and analysis in R. Then use this function to switch back for publication.
}
\details{
The function will try to match the names in \code{x} with the names in \code{ori_names}.
If the names in \code{x} are not in \code{ori_names}, the function will return \code{NA}.
}
\examples{
ori_names <- c("xx (mg/dl)", "b*x", "Covid-19")
x <- c(make.names(ori_names), "aa")
unmake_names(x, ori_names)
}
