% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_roc.R
\name{time_roc_plot}
\alias{time_roc_plot}
\title{Calculate and plot time-dependent ROC curves}
\usage{
time_roc_plot(
  data,
  time_var,
  event_var,
  marker_var,
  times = c(12, 36, 60),
  weighting = "marginal",
  cause = 1,
  colors = NULL,
  title = FALSE,
  save_plot = FALSE,
  filename = "time_roc.png"
)
}
\arguments{
\item{data}{A data frame containing the survival time, event indicator, and marker variable.}

\item{time_var}{A string specifying the name of the survival time variable in the data frame.}

\item{event_var}{A string specifying the name of the event indicator variable in the data frame.}

\item{marker_var}{A string specifying the name of the marker variable in the data frame.}

\item{times}{A numeric vector of times at which to compute the time-dependent ROC curves.}

\item{weighting}{A character string specifying the weighting method. Default is "marginal".
See \code{timeROC::timeROC()} for details.}

\item{cause}{The value of the event indicator that denotes the event of interest. Default is \code{1}.}

\item{colors}{A vector of colors to use for the ROC curves. If NULL, uses default colors.}

\item{title}{A logical value indicating whether to include a title. Default is \code{FALSE}.}

\item{save_plot}{A logical value indicating whether to save the plot to a file. Default is \code{FALSE}.}

\item{filename}{A string specifying the filename to save the plot. Default is "time_roc.png".}
}
\value{
A list containing:
\itemize{
\item time_roc: The timeROC result object.
\item plot: A ggplot object of the time-dependent ROC curves.
}
}
\description{
Calculate time-dependent ROC curves using the \code{timeROC} package and plot them using \code{ggplot2}.
}
\examples{
# Plot time-dependent ROC curves using lung dataset from survival package
library(survival)
data(cancer, package = "survival")
# Use age as the marker variable, plot at 6, 12, and 24 months
lung$status <- lung$status == 2
result <- time_roc_plot(lung, "time", "status", "age", times = c(180, 365, 730))
result$plot

# Save the plot to a file
# time_roc_plot(lung, "time", "status", "age", times = c(180, 365, 730), save_plot = TRUE)
}
