\name{body_weight_calculations}
\alias{body_weight_calculations}
\title{
Ideal Body Weight (IBW) and Adjusted Body Weight (ABW)
}
\description{
Calculates Ideal Body Weight (using the Devine Formula) and Adjusted Body Weight. These metrics are essential for calculating nutritional needs and dosing medications (e.g., aminoglycosides, acyclovir) in patients who are obese or have abnormal body composition.
}
\usage{
body_weight_calculations(sex, height, actual_weight,
                         height_units = "in", weight_units = "kg")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{height}{
Numeric. Patient height.
}
  \item{actual_weight}{
Numeric. Patient's current actual body weight.
}
  \item{height_units}{
String. Units for height input. Options: "in" (default) or "cm".
}
  \item{weight_units}{
String. Units for weight input. Options: "kg" (default) or "lbs".
}
}
\value{
A list containing:
\item{Ideal_Body_Weight_kg}{Calculated IBW based on Devine formula.}
\item{Adjusted_Body_Weight_kg}{Calculated ABW (IBW + 0.4 * (Actual - IBW)).}
\item{Actual_Body_Weight_kg}{Standardized actual weight in kg.}
\item{Percent_Over_IBW}{The percentage by which actual weight exceeds IBW.}
\item{Dosing_Suggestion}{Logic suggesting which weight to use for dosing based on obesity status.}
}
\references{
Devine BJ. Gentamicin therapy. Drug Intell Clin Pharm. 1974;8:650–655.
}
\examples{

# Example 1: Male, Normal Weight (70 in, 75 kg)
body_weight_calculations("male", 70, 75)

# Example 2: Female, Obese (160 cm, 90 kg)
# Height ~63 in. IBW = 45.5 + 2.3(3) = 52.4 kg.
# Actual 90 kg. ABW = 52.4 + 0.4(90-52.4) = 67.4 kg.
body_weight_calculations("female", 160, 90, "cm", "kg")
}
