\name{cirs_geriatric_score}
\alias{cirs_geriatric_score}
\title{
Cumulative Illness Rating Scale for Geriatrics (CIRS-G)
}
\description{
Calculates the CIRS-G score, a comprehensive method for quantifying the burden of chronic illness in geriatric patients. The scale evaluates 14 body systems, each rated from 0 (None) to 4 (Extremely Severe), providing a total score and severity index.
}
\usage{
cirs_geriatric_score(heart, vascular, hematopoietic, respiratory, eent,
                     upper_gi, lower_gi, liver, renal, gu, msk, neuro,
                     endocrine, psych)
}
\arguments{
  \item{heart}{Numeric (0-4). Heart disease severity.}
  \item{vascular}{Numeric (0-4). Vascular disease severity.}
  \item{hematopoietic}{Numeric (0-4). Hematopoietic system severity.}
  \item{respiratory}{Numeric (0-4). Respiratory system severity.}
  \item{eent}{Numeric (0-4). Eyes, Ears, Nose, Throat, Larynx severity.}
  \item{upper_gi}{Numeric (0-4). Upper GI severity.}
  \item{lower_gi}{Numeric (0-4). Lower GI severity.}
  \item{liver}{Numeric (0-4). Liver severity.}
  \item{renal}{Numeric (0-4). Renal severity.}
  \item{gu}{Numeric (0-4). Genitourinary severity.}
  \item{msk}{Numeric (0-4). Musculoskeletal/Integumentary severity.}
  \item{neuro}{Numeric (0-4). Neurological severity.}
  \item{endocrine}{Numeric (0-4). Endocrine/Metabolic severity.}
  \item{psych}{Numeric (0-4). Psychiatric/Behavioral severity.}
}
\details{
\strong{General Scoring Guidelines:}
0: None.
1: Mild (Impairment does not interfere with normal activity).
2: Moderate (Impairment interferes with normal activity; meds may be needed).
3: Severe (Significant disability; chronic problems are uncontrollably).
4: Extremely Severe (Life-threatening; emergency treatment required).
}
\value{
A list containing:
\item{CIRS_G_Total_Score}{Sum of all items (Range 0-56).}
\item{Severity_Index}{Total score divided by the number of categories (14).}
\item{Number_of_Categories_Endorsed}{Count of systems with a score > 0.}
}
\references{
Miller MD, Paradis CF, Houck PR, et al. Rating chronic medical illness burden in geropsychiatric practice and research: application of the Cumulative Illness Rating Scale. Psychiatry Res. 1992;41(3):237-248. doi:10.1016/0165-1781(92)90005-n
}
\examples{

# Example 1: High Burden
# Moderate heart (2), Severe vascular (3), Mild renal (1), others 0
# Score = 6
cirs_geriatric_score(2, 3, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0)

# Example 2: Low Burden
# Mild MSK (1), others 0
# Score = 1
cirs_geriatric_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0)
}
