\name{cll_ipi_score}
\alias{cll_ipi_score}
\title{
International Prognostic Index for Chronic Lymphocytic Leukemia (CLL-IPI)
}
\description{
Calculates the CLL-IPI score to predict 5-year overall survival and stratify risk in patients with Chronic Lymphocytic Leukemia. The index integrates genetic, biochemical, and clinical variables.
}
\usage{
cll_ipi_score(tp53_deleted_or_mutated, ighv_unmutated,
              beta2_microglobulin_gt_3_5, clinical_stage_advanced, age_gt_65)
}
\arguments{
  \item{tp53_deleted_or_mutated}{
Numeric (0 or 1). Presence of del(17p) and/or TP53 mutation. (1 = Yes, +4 points).
}
  \item{ighv_unmutated}{
Numeric (0 or 1). IGHV mutational status is unmutated. (1 = Yes, +2 points).
}
  \item{beta2_microglobulin_gt_3_5}{
Numeric (0 or 1). Serum Beta-2 Microglobulin > 3.5 mg/L. (1 = Yes, +2 points).
}
  \item{clinical_stage_advanced}{
Numeric (0 or 1). Rai Stage I-IV or Binet Stage B-C. (1 = Yes, +1 point).
}
  \item{age_gt_65}{
Numeric (0 or 1). Patient age > 65 years. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{CLL_IPI_Score}{The calculated risk score (Range 0-10).}
\item{Risk_Group}{Classification (Low 0-1, Intermediate 2-3, High 4-6, Very High 7-10).}
\item{Est_5_Year_Overall_Survival}{Estimated 5-year survival probability.}
\item{Recommendation}{General treatment guidance based on risk group.}
}
\references{
Kutsch N, Bahlo J, Robrecht S, et al. International Prognostic Index for Chronic Lymphocytic Leukemia (CLL-IPI): an international meta-analysis. Lancet Oncol. 2016;17(6):779-790. doi:10.1016/S1470-2045(16)30029-8
}
\examples{

# Example 1: Very High Risk
# TP53 deleted (+4), IGHV unmutated (+2), B2M > 3.5 (+2), Stage I (+1), Age 70 (+1)
# Score = 10
cll_ipi_score(1, 1, 1, 1, 1)

# Example 2: Low Risk
# No mutations, Normal B2M, Stage 0, Age 60
# Score = 0
cll_ipi_score(0, 0, 0, 0, 0)
}
