\name{evendo_esophageal_varices_score}
\alias{evendo_esophageal_varices_score}
\title{
EVendo Score for Esophageal Varices Screening
}
\description{
Structures the clinical inputs for the EVendo score, a predictive tool for identifying esophageal varices in patients with cirrhosis. The score utilizes Platelet count, INR, and Serum Urea to risk-stratify patients and determine the necessity of screening endoscopy.
}
\usage{
evendo_esophageal_varices_score(platelet_count, inr, urea, urea_units = "mg/dL")
}
\arguments{
  \item{platelet_count}{
Numeric. Platelet count in 10^9/L (or x1000/uL).
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{urea}{
Numeric. Serum Urea level.
}
  \item{urea_units}{
String. Units for the urea input. Options: "mg/dL" (Urea), "BUN_mg_dL" (BUN to be converted), "mmol/L" (Urea SI units).
}
}
\value{
A list containing:
\item{Risk_Factors_Present}{Count of abnormal parameters (Low Platelets, High INR, High Urea).}
\item{Interpretation}{General clinical guidance based on the presence of risk factors.}
\item{Inputs}{Standardized input values.}
}
\references{
Tellez-Avila F, Chávez-Tapia N, Franco-Guzmán AM, et al. EVendo score: A simple model for the prediction of esophageal varices in patients with cirrhosis. Turk J Gastroenterol. 2019;30(2):168-173. doi:10.5152/tjg.2018.18055
}
\examples{

# Example 1: High Risk
# Plt 80, INR 1.8, Urea 50 mg/dL
evendo_esophageal_varices_score(80, 1.8, 50)

# Example 2: Low Risk
# Plt 200, INR 1.0, Urea 20 mg/dL
evendo_esophageal_varices_score(200, 1.0, 20)
}
