\name{interchest_score}
\alias{interchest_score}
\title{
INTERCHEST Clinical Prediction Rule for Chest Pain in Primary Care
}
\description{
Calculates the INTERCHEST score to assess the risk of unstable coronary artery disease (UCAD) in primary care patients presenting with chest pain. The score uses simple history and physical exam findings to stratify patients into low and high risk groups for urgent referral.
}
\usage{
interchest_score(history_cad, age_risk, effort_pain, palpation_pain,
                 physician_suspicion, pressure_discomfort)
}
\arguments{
  \item{history_cad}{
Numeric (0 or 1). History of coronary artery disease (MI, PCI, CABG). (1 = Yes, +1 point).
}
  \item{age_risk}{
Numeric (0 or 1). Age threshold (Female >= 65, Male >= 55 years). (1 = Yes, +1 point).
}
  \item{effort_pain}{
Numeric (0 or 1). Chest pain related to effort. (1 = Yes, +1 point).
}
  \item{palpation_pain}{
Numeric (0 or 1). Pain reproducible by palpation. (1 = Yes, -1 point).
}
  \item{physician_suspicion}{
Numeric (0 or 1). Physician initially suspected a serious condition. (1 = Yes, +1 point).
}
  \item{pressure_discomfort}{
Numeric (0 or 1). Chest discomfort feels like "pressure" (rather than sharp/stabbing). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{INTERCHEST_Score}{The calculated total score (Range -1 to 5).}
\item{Risk_Category}{Classification (Very Low <= 1, Low 2, High >= 3).}
\item{Recommendation}{Guidance on urgent vs. non-urgent follow-up.}
}
\references{
Alghamdi A, Alghamdi R, Oliver G, et al. Enhanced triage for chest pain in primary care: a prediction rule for unstable coronary artery disease. Eur J Emerg Med. 2019;26(4):269-275. doi:10.1097/MEJ.0000000000000574
}
\examples{

# Example 1: Very Low Risk
# Pain reproducible by palpation only
# Score = -1
interchest_score(0, 0, 0, 1, 0, 0)

# Example 2: High Risk
# Hx CAD (+1), Effort pain (+1), MD Suspicion (+1)
# Score = 3
interchest_score(1, 0, 1, 0, 1, 0)
}
