\name{isth_dic_score}
\alias{isth_dic_score}
\title{
ISTH Criteria for Disseminated Intravascular Coagulation (DIC)
}
\description{
Calculates the score for Disseminated Intravascular Coagulation (DIC) based on the International Society on Thrombosis and Haemostasis (ISTH) criteria. This scoring system assesses platelet count, fibrin-related markers (e.g., D-dimer), prothrombin time prolongation, and fibrinogen levels to determine if a patient has overt DIC.
}
\usage{
isth_dic_score(platelet_count, pt_prolongation_seconds, fibrinogen_g_l,
               fibrin_marker_increase)
}
\arguments{
  \item{platelet_count}{
Numeric. Platelet count in x 10^9/L (or x 10^3/uL).
< 50: +2 points.
50-100: +1 point.
> 100: 0 points.
}
  \item{pt_prolongation_seconds}{
Numeric. Prolongation of Prothrombin Time (PT) in seconds (Patient PT - Normal/Control PT).
>= 6 sec: +2 points.
3 - < 6 sec: +1 point.
< 3 sec: 0 points.
}
  \item{fibrinogen_g_l}{
Numeric. Fibrinogen level in g/L.
< 1.0 g/L: +1 point.
>= 1.0 g/L: 0 points.
}
  \item{fibrin_marker_increase}{
String. Level of increase in fibrin-related markers (e.g., D-dimer, FDP).
"none": No increase (0 points).
"moderate": Moderate increase (e.g., > Upper Limit of Normal; +2 points).
"strong": Strong increase (e.g., > 5x Upper Limit of Normal; +3 points).
}
}
\value{
A list containing:
\item{ISTH_DIC_Score}{The calculated total score (Range 0-8).}
\item{Interpretation}{Diagnostic interpretation based on the threshold of 5.}
}
\references{
Taylor FB Jr, Toh CH, Hoots WK, et al. Towards definition, clinical and laboratory criteria, and a scoring system for disseminated intravascular coagulation. Thromb Haemost. 2001;86(5):1327-1330.
}
\examples{

# Example 1: Overt DIC
# Platelets 40k (+2), Strong D-dimer (+3), PT prolonged 4s (+1), Fib 0.8 (+1)
# Score = 7
isth_dic_score(40, 4, 0.8, "strong")

# Example 2: Non-overt DIC
# Platelets 120k (0), Moderate D-dimer (+2), PT prolonged 1s (0), Fib 2.0 (0)
# Score = 2
isth_dic_score(120, 1, 2.0, "moderate")
}
