\name{perioperative_anticoagulation_pause}
\alias{perioperative_anticoagulation_pause}
\title{
Perioperative Anticoagulation Use for Surgery Evaluation (PAUSE)
}
\description{
Provides standardized perioperative management recommendations for patients with Atrial Fibrillation (AF) who are taking a Direct Oral Anticoagulant (DOAC) and require an elective surgery or procedure. The logic follows the PAUSE study protocol to minimize bleeding risk while preventing thromboembolism without heparin bridging.
}
\usage{
perioperative_anticoagulation_pause(drug_name, procedure_bleeding_risk, crcl_ml_min)
}
\arguments{
  \item{drug_name}{
String. The DOAC being used. Options: "apixaban", "rivaroxaban", "edoxaban", "dabigatran".
}
  \item{procedure_bleeding_risk}{
String. The bleeding risk associated with the planned procedure. Options: "low", "high".
}
  \item{crcl_ml_min}{
Numeric. Creatinine Clearance in mL/min. Used specifically to adjust interruption windows for Dabigatran or check validity for Xa inhibitors.
}
}
\value{
A list containing:
\item{PreOp_Recommendation}{Instruction on how many days prior to surgery to stop the medication.}
\item{Last_Dose_Timing}{Specific guidance on when the final pre-operative dose should be taken.}
\item{PostOp_Resumption}{Guidance on when to restart the medication based on bleeding risk.}
}
\references{
Douketis JD, Spyropoulos AC, Duncan J, et al. Perioperative Management of Patients With Atrial Fibrillation Receiving a Direct Oral Anticoagulant. JAMA Intern Med. 2019;179(11):1469-1478. doi:10.1001/jamainternmed.2019.2431
}
\examples{
# Example 1: Apixaban, Low Risk Procedure
perioperative_anticoagulation_pause("apixaban", "low", 60)

# Example 2: Dabigatran, High Risk Procedure, Renal Impairment (CrCl 40)
perioperative_anticoagulation_pause("dabigatran", "high", 40)
}
