\name{saps_3_score}
\alias{saps_3_score}
\title{
Simplified Acute Physiology Score III (SAPS 3)
}
\description{
Calculates the SAPS 3 score and predicted hospital mortality for ICU patients. The score uses data available within 1 hour of ICU admission to assess severity of illness based on 20 variables covering patient characteristics, reasons for admission, and physiological derangement.
}
\usage{
saps_3_score(age, admission_type, admission_source, length_of_stay_days,
             anatomical_system, infection_type, gcs_score, bilirubin_mg_dl,
             temperature_c, creatinine_mg_dl, heart_rate, wbc_count, ph_level,
             platelet_count, systolic_bp, mechanical_ventilation, pao2_fio2_ratio,
             vasoactive_drugs, comorbidities)
}
\arguments{
  \item{age}{Numeric. Patient age in years.}
  \item{admission_type}{String. "medical", "scheduled_surgical", or "unscheduled_surgical".}
  \item{admission_source}{String. "ward", "emergency_room", "other_icu", "other_hospital", or "operating_room".}
  \item{length_of_stay_days}{Numeric. Days in hospital prior to ICU admission.}
  \item{anatomical_system}{String. Primary system involved (e.g., "cardiovascular", "digestive", "neurologic", "respiratory", "renal", "hematologic", "metabolic", "trauma", "orthopedic", "gynecology", "other").}
  \item{infection_type}{String. "none", "respiratory", or "nosocomial".}
  \item{gcs_score}{Numeric. Lowest Glasgow Coma Scale score.}
  \item{bilirubin_mg_dl}{Numeric. Highest Total Bilirubin (mg/dL).}
  \item{temperature_c}{Numeric. Highest Body Temperature (Celsius).}
  \item{creatinine_mg_dl}{Numeric. Highest Serum Creatinine (mg/dL).}
  \item{heart_rate}{Numeric. Highest Heart Rate (bpm).}
  \item{wbc_count}{Numeric. Highest Leukocytes (x10^3/mm^3).}
  \item{ph_level}{Numeric. Lowest arterial pH.}
  \item{platelet_count}{Numeric. Lowest Platelet count (x10^3/mm^3).}
  \item{systolic_bp}{Numeric. Lowest Systolic Blood Pressure (mmHg).}
  \item{mechanical_ventilation}{Numeric (0 or 1). Is the patient mechanically ventilated?}
  \item{pao2_fio2_ratio}{Numeric. Ratio of PaO2 to FiO2 (if ventilated).}
  \item{vasoactive_drugs}{Numeric (0 or 1). Is the patient receiving vasoactive drugs?}
  \item{comorbidities}{Vector of strings. List of comorbidities: "cancer_therapy", "hematologic_cancer", "cirrhosis", "aids", "heart_failure_nyha4", "metastatic_cancer", "immunosuppression".}
}
\value{
A list containing:
\item{SAPS_3_Score}{The calculated SAPS 3 score.}
\item{Predicted_Hospital_Mortality}{The estimated probability of hospital mortality percentage.}
}
\references{
Moreno RP, Metnitz PG, Almeida E, et al. SAPS 3--From evaluation of the patient to evaluation of the intensive care unit. Part 2: Development of a prognostic model for hospital mortality at ICU admission. Intensive Care Med. 2005;31(10):1345-1355.
}
\examples{
saps_3_score(
  age = 65,
  admission_type = "medical",
  admission_source = "emergency_room",
  length_of_stay_days = 1,
  anatomical_system = "respiratory",
  infection_type = "respiratory",
  gcs_score = 14,
  bilirubin_mg_dl = 0.8,
  temperature_c = 38.5,
  creatinine_mg_dl = 1.0,
  heart_rate = 110,
  wbc_count = 15,
  ph_level = 7.35,
  platelet_count = 250,
  systolic_bp = 100,
  mechanical_ventilation = 0,
  pao2_fio2_ratio = 300,
  vasoactive_drugs = 0,
  comorbidities = NULL
)
}
