\name{seattle_heart_failure_model}
\alias{seattle_heart_failure_model}
\title{
Seattle Heart Failure Model (SHFM)
}
\description{
Calculates the Seattle Heart Failure Model (SHFM) risk score to predict 1-, 2-, and 5-year survival and median life expectancy in patients with heart failure. The model integrates clinical status, pharmacological and device therapy, and laboratory parameters.
}
\usage{
seattle_heart_failure_model(age, sex, nyha_class, ejection_fraction, systolic_bp,
                            ischemic_etiology, weight_kg,
                            diuretic_daily_furosemide_equiv_mg,
                            hemoglobin_g_dl, lymphocyte_percent, uric_acid_mg_dl,
                            sodium_meq_l, cholesterol_mg_dl, qrs_duration_ms,
                            ace_inhibitor, beta_blocker, statin, allopurinol,
                            aldosterone_blocker, icd_device, crt_device)
}
\arguments{
  \item{age}{Numeric. Patient age in years.}
  \item{sex}{String. "Male" or "Female".}
  \item{nyha_class}{Numeric. NYHA Functional Class (1-4).}
  \item{ejection_fraction}{Numeric. Left Ventricular Ejection Fraction (LVEF) in percent.}
  \item{systolic_bp}{Numeric. Systolic Blood Pressure in mmHg.}
  \item{ischemic_etiology}{Numeric (0 or 1). Ischemic etiology of heart failure (1 = Yes).}
  \item{weight_kg}{Numeric. Patient weight in kilograms.}
  \item{diuretic_daily_furosemide_equiv_mg}{Numeric. Total daily diuretic dose in furosemide equivalents (mg).}
  \item{hemoglobin_g_dl}{Numeric. Hemoglobin level in g/dL.}
  \item{lymphocyte_percent}{Numeric. Lymphocyte percentage of total WBC.}
  \item{uric_acid_mg_dl}{Numeric. Serum Uric Acid level in mg/dL.}
  \item{sodium_meq_l}{Numeric. Serum Sodium level in mEq/L.}
  \item{cholesterol_mg_dl}{Numeric. Total Cholesterol in mg/dL.}
  \item{qrs_duration_ms}{Numeric. QRS duration in ms (used for CRT benefit assessment).}
  \item{ace_inhibitor}{Numeric (0 or 1). Use of ACE Inhibitor or ARB. (1 = Yes).}
  \item{beta_blocker}{Numeric (0 or 1). Use of Beta-Blocker. (1 = Yes).}
  \item{statin}{Numeric (0 or 1). Use of Statin. (1 = Yes).}
  \item{allopurinol}{Numeric (0 or 1). Use of Allopurinol. (1 = Yes).}
  \item{aldosterone_blocker}{Numeric (0 or 1). Use of Aldosterone Blocker (e.g., Spironolactone). (1 = Yes).}
  \item{icd_device}{Numeric (0 or 1). Presence of Implantable Cardioverter Defibrillator (ICD). (1 = Yes).}
  \item{crt_device}{Numeric (0 or 1). Presence of Cardiac Resynchronization Therapy (CRT). (1 = Yes).}
}
\value{
A list containing:
\item{SHFM_Score}{The calculated log-hazard score.}
\item{Est_1_Year_Survival}{Estimated survival probability at 1 year.}
\item{Est_2_Year_Survival}{Estimated survival probability at 2 years.}
\item{Est_5_Year_Survival}{Estimated survival probability at 5 years.}
\item{Est_Median_Survival}{Estimated median life expectancy in years.}
}
\references{
Levy WC, Mozaffarian D, Linker DT, et al. The Seattle Heart Failure Model: prediction of survival in heart failure. Circulation. 2006;113(11):1424-1433. doi:10.1161/CIRCULATIONAHA.105.584102
}
\examples{
# Example: High Risk Patient
seattle_heart_failure_model(
  age = 75, sex = "male", nyha_class = 3, ejection_fraction = 25,
  systolic_bp = 110, ischemic_etiology = 1, weight_kg = 80,
  diuretic_daily_furosemide_equiv_mg = 80, hemoglobin_g_dl = 11,
  lymphocyte_percent = 15, uric_acid_mg_dl = 8.0, sodium_meq_l = 135,
  cholesterol_mg_dl = 180, qrs_duration_ms = 120,
  ace_inhibitor = 1, beta_blocker = 0, statin = 0, allopurinol = 0,
  aldosterone_blocker = 0, icd_device = 0, crt_device = 0
)
}
