\name{shanghai_pancreatitis_score}
\alias{shanghai_pancreatitis_score}
\title{
Shanghai Score for Severe Acute Pancreatitis
}
\description{
Calculates the Shanghai Score to predict the risk of Severe Acute Pancreatitis (SAP). This scoring system uses simple, objective clinical and laboratory parameters available within 24 hours of admission to stratify patients into low or high risk categories.
}
\usage{
shanghai_pancreatitis_score(bmi, age, pleural_effusion, hematocrit,
                            creatinine, ldh, creatinine_units = "mg/dL")
}
\arguments{
  \item{bmi}{
Numeric. Body Mass Index in kg/m^2. (>= 25 adds 1 point).
}
  \item{age}{
Numeric. Patient age in years. (>= 60 adds 1 point).
}
  \item{pleural_effusion}{
Numeric (0 or 1). Presence of pleural effusion on imaging (CXR or CT). (1 = Yes, adds 1 point).
}
  \item{hematocrit}{
Numeric. Hematocrit percentage on admission. (>= 46\% adds 1 point).
}
  \item{creatinine}{
Numeric. Serum creatinine on admission. (>= 1.6 mg/dL adds 1 point).
}
  \item{ldh}{
Numeric. Lactate Dehydrogenase level in U/L on admission. (>= 340 U/L adds 1 point).
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{Shanghai_Score}{The calculated total score (Range 0-6).}
\item{Risk_Category}{Interpretation of risk (Low Risk < 2, High Risk >= 2).}
}
\references{
Liu Y, et al. A simple scoring system to predict the severity of acute pancreatitis. World J Gastroenterol. 2017;23(44):7847-7853. doi:10.3748/wjg.v23.i44.7847
}
\examples{

# Example 1: High Risk
# BMI 28 (+1), Age 65 (+1), Pleural Effusion (+1), Hct 48 (+1), Cr 1.8 (+1), LDH 400 (+1)
# Score = 6
shanghai_pancreatitis_score(28, 65, 1, 48, 1.8, 400)

# Example 2: Low Risk
# BMI 22, Age 40, No effusion, Hct 40, Cr 0.8, LDH 200
# Score = 0
shanghai_pancreatitis_score(22, 40, 0, 40, 0.8, 200)
}
