% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_geometry_column.R
\name{drop_geometry_column}
\alias{drop_geometry_column}
\title{Removes \code{geometry} Column From \code{sf} Dataframes}
\usage{
drop_geometry_column(df = NULL, quiet = FALSE, ...)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
dataframe
}
\description{
Remove geometry column from sf objects
}
\examples{
data(vi_smol)

#creating fake geometry column without sf loaded
vi_smol$geometry <- NA
attr(
  x = vi_smol,
  which = "sf_column"
  ) <- "geometry"

#check new attribute
attributes(vi_smol)$sf_column

#drop geometry column
df <- drop_geometry_column(
  df = vi_smol
  )

#checking that the geometry was droppped
"geometry" \%in\% colnames(df)
attributes(df)$sf_column

}
\seealso{
Other argument_validation: 
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\author{
Blas M. Benito, PhD
}
\concept{argument_validation}
