% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%lt\%}
\alias{\%lt\%}
\title{Perform less than comparison between two objects}
\usage{
x1 \%lt\% x2
}
\arguments{
\item{x1}{The first object to compare}

\item{x2}{The second object to compare}
}
\value{
A single TRUE or FALSE value indicating the results of the comparison.
}
\description{
The goal of the comparison operators is to return a TRUE
or FALSE value when any two objects are compared.  The operators provides a
simple, reliable equality check that allows comparing
of NULLs, NA values, and atomic data types without error. This operator
performs a less than comparison.

For data frames, the operator will compare all values in all columns, and return
a single TRUE if all values in the second data frame are less than the
corresponding values in the first data frame.
}
\examples{
# Comparing of NULLs and NA
NULL \%lt\% NULL        # FALSE
NULL \%lt\% NA          # FALSE
NA \%lt\% NA            # FALSE
1 \%lt\% NULL           # FALSE
1 \%lt\% NA             # FALSE

# Comparing of atomic values
1 \%lt\% 1              # FALSE
2 \%lt\% 1              # FALSE
1 \%lt\% 2              # TRUE
"one" \%lt\% "one"      # FALSE
1 \%lt\% "one"          # FALSE
1 \%lt\% Sys.Date()     # TRUE (Sys.Date() is a number)

# Comparing of vectors
v1 <- c(0, 1, 2)
v2 <- c(1, 2, 3)
v3 <- c(2, 3, 4)
v1 \%lt\% v1            # FALSE
v1 \%lt\% v2            # TRUE
v2 \%lt\% v1            # FALSE
v2 \%lt\% v3            # TRUE

# Comparing of data frames
d1 <- data.frame(A = v1, B = v2)
d2 <- data.frame(A = v2, B = v3)
d1 \%lt\% d1            # FALSE
d1 \%lt\% d2            # TRUE
d2 \%lt\% d1            # FALSE

# Mixing it up
d1 \%lt\% NULL          # FALSE
v1 \%lt\% d1            # FALSE
1 \%lt\% v1             # FALSE
}
\seealso{
Other operators: 
\code{\link{\%eq\%}()},
\code{\link{\%ge\%}()},
\code{\link{\%gt\%}()},
\code{\link{\%le\%}()},
\code{\link{\%ne\%}()},
\code{\link{\%p\%}()}
}
\concept{operators}
