% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{with_restarts}
\alias{with_restarts}
\title{Multiple Random Restarts}
\usage{
with_restarts(solver, n, sampler, max_reject = 100L)
}
\arguments{
\item{solver}{A solver function}

\item{n}{Number of restarts (including the provided theta0)}

\item{sampler}{Function that generates random starting points.
Called with no arguments, should return a parameter vector.
Samples are automatically constrained using problem$constraint.}

\item{max_reject}{Maximum rejection attempts per sample before projection}
}
\value{
A new solver function with restart capability
}
\description{
Runs a solver from multiple starting points and returns the best result.
Essential for problems with multiple local optima.
}
\details{
The sampler generates candidate starting points, which are automatically
filtered/projected using the problem's constraint. This means samplers
can be simple distributions without constraint awareness.
}
\examples{
# 20 random restarts - constraint applied automatically from problem
sampler <- uniform_sampler(c(-10, 0), c(10, 5))
strategy <- with_restarts(gradient_ascent(), n = 20, sampler = sampler)

# Can also compose with other operators
strategy <- with_restarts(gradient_ascent(), n = 10, sampler = sampler) \%>>\%
  newton_raphson()

}
