% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrCombo.R
\name{as.data.frame.CorrCombo}
\alias{as.data.frame.CorrCombo}
\title{Coerce CorrCombo to a Data Frame}
\usage{
\method{as.data.frame}{CorrCombo}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{A \code{CorrCombo} object.}

\item{row.names}{Optional row names for the output data frame.}

\item{optional}{Logical. Passed to \code{data.frame()}.}

\item{...}{Additional arguments passed to \code{data.frame()}.}
}
\value{
A data frame where each row corresponds to a subset of variables. Columns are named
\code{VarName01}, \code{VarName02}, ..., up to the size of the largest subset. Subsets shorter than the
maximum length are padded with \code{NA}.
}
\description{
Converts a \code{CorrCombo} object into a data frame of variable combinations.
}
\examples{
set.seed(1)
mat <- matrix(rnorm(100), ncol = 10)
colnames(mat) <- paste0("V", 1:10)
res <- corrSelect(cor(mat), threshold = 0.5)
as.data.frame(res)
}
\seealso{
\code{\link{CorrCombo}}
}
