# tests/testthat/test-museum.R

test_that("museum_list returns all gaffe IDs", {
  ids <- museum_list()
  expect_type(ids, "character")
  expect_true("covfefe" %in% ids)
  expect_true("potatoe" %in% ids)
  expect_length(ids, 13)
})

test_that("museum_lookup returns gaffe details", {
  result <- museum_lookup("covfefe")
  expect_type(result, "list")
  expect_equal(result$original, "coverage")
  expect_equal(result$gaffe, "covfefe")
  expect_equal(result$person, "Donald Trump")
  expect_equal(result$year, 2017L)
})

test_that("museum_lookup handles unknown gaffe", {
  expect_error(museum_lookup("notreal"), "not found")
})

test_that("museum_random returns valid gaffe", {
  set.seed(42)
  result <- museum_random()
  expect_type(result, "list")
  expect_true(result$id %in% museum_list())
})

test_that("museum_by_person filters correctly", {
  trump <- museum_by_person("Trump")
  expect_true(all(grepl("Trump", trump$person)))
  expect_true(nrow(trump) >= 8)
})

test_that("museum_by_year filters correctly", {
  y2017 <- museum_by_year(2017)
  expect_true(all(y2017$year == 2017))
})

test_that("museum_by_type filters correctly", {
  blends <- museum_by_type("blend")
  expect_true(all(blends$typo_type == "blend"))
})
