% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_hierarchical_rate_and_count.R
\name{tbl_hierarchical_rate_and_count}
\alias{tbl_hierarchical_rate_and_count}
\alias{add_overall.tbl_hierarchical_rate_and_count}
\title{Hierarchical Rates and Counts}
\usage{
tbl_hierarchical_rate_and_count(
  data,
  variables,
  denominator,
  by = NULL,
  id = "USUBJID",
  label = NULL,
  digits = NULL,
  sort = NULL,
  label_overall_rate = "Total number of participants with at least one adverse event",
  label_overall_count = "Overall total number of events",
  label_rate = "Total number of participants with at least one adverse event",
  label_count = "Total number of events"
)

\method{add_overall}{tbl_hierarchical_rate_and_count}(
  x,
  last = FALSE,
  col_label = "All Participants  \\n(N = {style_roche_number(N)})",
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Hierarchical variables to summarize. Must be 2 or 3 variables.
Typical inputs are \code{c(AEBODSYS, AEDECOD)} for an SOC/AE summary
or \code{c(AEBODSYS, AEHLT, AEDECOD)} for an SOC/HLT/AE summary.

Variables must be specified in the nesting order.}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
used to define the denominator and enhance the output.
The argument is required for \code{tbl_hierarchical()} and optional for \code{tbl_hierarchical_count()}.
The \code{denominator} argument must be specified when \code{id} is used to calculate event rates.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
a single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}.}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
argument used to subset \code{data} to identify rows in \code{data} to calculate
event rates in \code{tbl_hierarchical()}.}

\item{label}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
used to override default labels in hierarchical table, e.g. \code{list(AESOC = "System Organ Class")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{digits}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies how summary statistics are rounded. Values may be either integer(s) or function(s).
If a theme is applied, the \code{digits} specifications of the theme is applied.}

\item{sort}{\emph{Optional} arguments passed to \code{gtsummary::sort_hierarchical(sort)}.}

\item{label_overall_rate}{(\code{string})\cr
String for the overall rate summary. Default is
\code{"Total number of participants with at least one adverse event"}.}

\item{label_overall_count}{(\code{string})\cr
String for the overall count summary. Default is
\code{"Overall total number of events"}.}

\item{label_rate}{(\code{string})\cr
String for the rate summary. Default is \code{"Overall total number of events"}.
\code{"Total number of participants with at least one adverse event"}.}

\item{label_count}{(\code{string})\cr
String for the overall count summary. Default is \code{"Total number of events"}.}

\item{x}{(\code{tbl_hierarchical_rate_and_count})\cr
a stratified 'tbl_hierarchical_rate_and_count' table}

\item{last}{(scalar \code{logical})\cr
Logical indicator to display overall column last in table.
Default is \code{FALSE}, which will display overall column first.}

\item{col_label}{(\code{string})\cr
String indicating the column label. Default is \code{"**Overall**  \nN = {style_number(N)}"}}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
a gtsummary table
}
\description{
A mix of adverse event rates (from \code{gtsummary::tbl_hierarchical()}) and counts
(from \code{gtsummary::tbl_hierarchical_count()}).
The function produces additional summary rows for the higher level nesting
variables providing both rates and counts.

When a hierarchical summary is filtered, the summary rows no longer provide
useful/consistent information.
When creating a filtered summary, use \code{gtsummary::tbl_hierarchical()} or
\code{gtsummary::tbl_hierarchical_count()} directly, followed by a call to
\code{gtsummary::filter_hierarchical()}.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
cards::ADAE[c(1, 2, 3, 8, 16), ] |>
  tbl_hierarchical_rate_and_count(
    variables = c(AEBODSYS, AEDECOD),
    denominator = cards::ADSL,
    by = TRTA
  ) |>
  add_overall(last = TRUE)
\dontshow{\}) # examplesIf}
}
