% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsRelativeDLT-class}
\alias{IncrementsRelativeDLT-class}
\alias{.IncrementsRelativeDLT}
\alias{IncrementsRelativeDLT}
\alias{.DefaultIncrementsRelativeDLT}
\title{\code{IncrementsRelativeDLT}}
\usage{
IncrementsRelativeDLT(intervals, increments)

.DefaultIncrementsRelativeDLT()
}
\arguments{
\item{intervals}{(\code{numeric})\cr see slot definition.}

\item{increments}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{IncrementsRelativeDLT}} is the class for increments control based on
relative differences in terms of DLTs.
}
\section{Slots}{

\describe{
\item{\code{intervals}}{(\code{integer})\cr a vector with the left bounds of the
relevant DLT intervals. For example, \code{intervals  = c(0, 1, 3)} specifies
three intervals (sets of DLTs: first, 0 DLT; second 1 or 2 DLTs; and the third
one, at least 3 DLTs. That means, the right bound of the intervals are
exclusive to the interval and the last interval goes from the last value to
infinity.}

\item{\code{increments}}{(\code{numeric})\cr a vector of maximum allowable relative
increments corresponding to \code{intervals}. IT must be of the same length
as the length of \code{intervals}.}
}}

\note{
This considers all DLTs across all cohorts observed so far.

Typically, end users will not use the \code{.DefaultIncrementsRelativeDLT()} function.
}
\examples{
# This is the example of a rule for:
# maximum doubling the dose if no DLTs were observed in the whole study so far
# or maximum increasing the dose by 1.33 if 1 or 2 DLTs were observed so far
# or maximum increasing the dose by 1.22 if 3 or more DLTs were observed so far.
my_increments <- IncrementsRelativeDLT(
  intervals = c(0, 1, 3),
  increments = c(1, 0.33, 0.2)
)
}
\seealso{
\link{IncrementsRelativeDLTCurrent} which only considers the DLTs
in the current cohort.
}
