% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{ModelEff-class}
\alias{ModelEff-class}
\alias{.ModelEff}
\alias{ModelEff}
\alias{.DefaultModelEff}
\title{\code{ModelEff}}
\usage{
.DefaultModelEff()
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{ModelEff}} is the parent class for efficacy models using pseudo data prior.
It is dedicated all efficacy models that have their prior specified in the
form of pseudo data (as if there is some data before the trial starts).

The \code{data} must obey the convention of the \code{\link{DataDual}} class. This refers to
any observed efficacy/biomarker responses (\code{w} in \code{\link{DataDual}}), the dose
levels at which these responses are observed (\code{x} in \code{\link{DataDual}}), all dose
levels considered in the study (\code{doseGrid} in \code{\link{DataDual}}), and finally
other specifications in \code{\link{DataDual}} class that can be used to generate prior
or posterior modal estimates or samples estimates for model parameter(s).
If no responses are observed, at least \code{doseGrid} has to be specified
in \code{data} for which prior modal estimates or samples can be obtained for
model parameters based on the specified pseudo data.
}
\section{Slots}{

\describe{
\item{\code{data}}{(\code{DataDual})\cr observed data that is used to obtain model
parameters estimates or samples (see details above).}
}}

\note{
Typically, end users will not use the \code{.DefaultModelEff()} function.
}
\seealso{
\code{\link{ModelTox}}.
}
