% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{PseudoSimulationsSummary-class}
\alias{PseudoSimulationsSummary-class}
\alias{.PseudoSimulationsSummary}
\alias{PseudoSimulationsSummary}
\alias{.DefaultPseudoSimulationsSummary}
\title{\code{PseudoSimulationsSummary}}
\usage{
.DefaultPseudoSimulationsSummary()
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This class captures the summary of pseudo-models simulations output.
Note that objects should not be created by users, therefore no
initialization function is provided for this class.
}
\section{Slots}{

\describe{
\item{\code{target_end_of_trial}}{(\code{numeric})\cr the target probability of DLE wanted at the end of a trial}

\item{\code{target_dose_end_of_trial}}{(\code{numeric})\cr the dose level corresponds to the target probability
of DLE wanted at the end of a trial, TDEOT}

\item{\code{target_dose_end_of_trial_at_dose_grid}}{(\code{numeric})\cr the dose level at dose grid corresponds to the
target probability of DLE wanted at the end of a trial}

\item{\code{target_during_trial}}{(\code{numeric})\cr the target probability of DLE wanted during a trial}

\item{\code{target_dose_during_trial}}{(\code{numeric})\cr the dose level corresponds to the target probability of DLE
wanted during the trial. TDDT}

\item{\code{target_dose_during_trial_at_dose_grid}}{(\code{numeric})\cr the dose level at dose grid corresponds to the
target probability of DLE wanted during a trial}

\item{\code{tdeot_summary}}{(\code{table})\cr the six-number table summary, include the lowest, the 25th percentile
(lower quartile), the 50th percentile (median), the mean, the 75th percentile and the highest values of the
final dose levels obtained corresponds to the target probability of DLE
want at the end of a trial across all simulations}

\item{\code{tddt_summary}}{(\code{table})\cr the six-number table summary, include the lowest, the 25th percentile
(lower quartile), the 50th percentile (median), the mean, the 75th percentile and the highest values of the
final dose levels obtained corresponds to the target probability of DLE
want during a trial across all simulations}

\item{\code{final_dose_rec_summary}}{(\code{table})\cr the six-number table summary, include the lowest, the 25th percentile
(lower quartile), the 50th percentile (median), the mean, the 75th percentile and the highest values of the
final optimal doses, which is either the TDEOT when only DLE response are incorporated into
the escalation procedure or the minimum of the TDEOT and Gstar when DLE and efficacy responses are
incorporated, across all simulations}

\item{\code{ratio_tdeot_summary}}{(\code{table})\cr the six-number summary table of the final ratios of the upper to the
lower 95\% credibility intervals of the final TDEOTs across all simulations}

\item{\code{final_ratio_summary}}{(\code{table})\cr the six-number summary table of the final ratios of the upper to the
lower 95\% credibility intervals of the final optimal doses across all simulations}

\item{\code{nsim}}{(\code{integer})\cr number of simulations}

\item{\code{prop_dle}}{(\code{numeric})\cr proportions of DLE in the trials}

\item{\code{mean_tox_risk}}{(\code{numeric})\cr mean toxicity risks for the patients}

\item{\code{dose_selected}}{(\code{numeric})\cr doses selected as MTD (target_dose_end_of_trial)}

\item{\code{tox_at_doses_selected}}{(\code{numeric})\cr true toxicity at doses selected}

\item{\code{prop_at_target_end_of_trial}}{(\code{numeric})\cr Proportion of trials selecting at the dose_grid closest below the
MTD, the target_dose_end_of_trial}

\item{\code{prop_at_target_during_trial}}{(\code{numeric})\cr Proportion of trials selecting at the dose_grid closest below
the target_dose_during_trial}

\item{\code{dose_most_selected}}{(\code{numeric})\cr dose most often selected as MTD}

\item{\code{obs_tox_rate_at_dose_most_selected}}{(\code{numeric})\cr observed toxicity rate at dose most often
selected}

\item{\code{n_obs}}{(\code{integer})\cr number of patients overall}

\item{\code{n_above_target_end_of_trial}}{(\code{integer})\cr number of patients treated above target_dose_end_of_trial}

\item{\code{n_above_target_during_trial}}{(\code{integer})\cr number of patients treated above target_dose_during_trial}

\item{\code{dose_grid}}{(\code{numeric})\cr the dose grid that has been used}

\item{\code{fit_at_dose_most_selected}}{(\code{numeric})\cr fitted toxicity rate at dose most often selected}

\item{\code{mean_fit}}{(\code{list})\cr list with the average, lower (2.5\%) and upper (97.5\%)
quantiles of the mean fitted toxicity at each dose level}

\item{\code{stop_report}}{(\code{matrix})\cr matrix of stopping rule outcomes}
}}

\note{
Typically, end users will not use the \code{.DefaultPseudoSimulationsSummary()} function.
}
