% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{SafetyWindowConst-class}
\alias{SafetyWindowConst-class}
\alias{.SafetyWindowConst}
\alias{SafetyWindowConst}
\alias{.DefaultSafetyWindowConst}
\title{\code{SafetyWindowConst}}
\usage{
SafetyWindowConst(gap, follow, follow_min)

.DefaultSafetyWindowConst()
}
\arguments{
\item{gap}{see slot definition.}

\item{follow}{see slot definition.}

\item{follow_min}{see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{SafetyWindowConst}} is the class for safety window length and it is used
when the \code{gap} should be kept constant across cohorts (though it may vary
within a cohort).
}
\section{Slots}{

\describe{
\item{\code{gap}}{(\code{integer})\cr a vector, the constant gap between patients.}

\item{\code{follow}}{(\code{count})\cr how long to follow each patient. The period of time
that each patient in the cohort needs to be followed before the next cohort
opens.}

\item{\code{follow_min}}{(\code{count})\cr minimum follow up. At least one patient in the
cohort needs to be followed at the minimal follow up time.}
}}

\note{
Typically, end users will not use the \code{.DefaultSafetyWindowConst()} function.
}
\examples{
# This is to have along the study constant parameters settings of safety window
# length, regardless of the cohort size.
my_win_len <- SafetyWindowConst(
  gap = c(7, 5, 3),
  follow = 7,
  follow_min = 14
)
}
