% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-methods.R
\name{&,Stopping,Stopping-method}
\alias{&,Stopping,Stopping-method}
\alias{and-Stopping-Stopping}
\title{Combine Two Stopping Rules with AND}
\usage{
\S4method{&}{Stopping,Stopping}(e1, e2)
}
\arguments{
\item{e1}{(\code{Stopping})\cr first stopping rule object.}

\item{e2}{(\code{Stopping})\cr second stopping rule object.}
}
\value{
The \code{\link{StoppingAll}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The method combining two atomic stopping rules.
}
\examples{
## Example of combining two atomic stopping rules with an AND ('&') operator

myStopping1 <- StoppingMinCohorts(nCohorts = 3)
myStopping2 <- StoppingTargetProb(target = c(0.2, 0.35), prob = 0.5)

myStopping <- myStopping1 & myStopping2
}
