% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\name{efficacy}
\alias{efficacy}
\alias{efficacy,numeric,Effloglog,Samples-method}
\alias{efficacy-Effloglog}
\alias{efficacy,numeric,Effloglog,missing-method}
\alias{efficacy-Effloglog-noSamples}
\alias{efficacy,numeric,EffFlexi,Samples-method}
\alias{efficacy-EffFlexi}
\title{Computing Expected Efficacy for a Given Dose, Model and Samples}
\usage{
efficacy(dose, model, samples, ...)

\S4method{efficacy}{numeric,Effloglog,Samples}(dose, model, samples)

\S4method{efficacy}{numeric,Effloglog,missing}(dose, model)

\S4method{efficacy}{numeric,EffFlexi,Samples}(dose, model, samples)
}
\arguments{
\item{dose}{(\code{numeric})\cr the dose which is targeted.
The following recycling rule applies when \code{samples} is not missing: vectors
of size 1 will be recycled to the size of the sample
(i.e. \code{size(samples)}). Otherwise, \code{dose} must have the same
size as the sample.}

\item{model}{(\code{ModelEff})\cr the efficacy model with pseudo data prior.}

\item{samples}{(\code{Samples})\cr samples of model's parameters that will be
used to compute expected efficacy values. Can also be missing for some
models.}

\item{...}{model specific parameters when \code{samples} are not used.}
}
\value{
A \code{numeric} vector with the values of expected efficacy.
If non-scalar \code{samples} were used, then every element in the returned vector
corresponds to one element of a sample. Hence, in this case, the output
vector is of the same length as the sample vector. If scalar \code{samples} were
used or no \code{samples} were used, e.g. for pseudo DLE/toxicity \code{model},
then the output is of the same length as the length of the \code{dose}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function that computes the value of expected efficacy at a specified dose
level, based on the model specific parameters. The model parameters (samples)
are obtained based on prior specified in form of pseudo data combined with
observed responses (if any).
}
\details{
The \code{efficacy()} function computes the expected efficacy for given
doses, using samples of the model parameter(s).
If you work with multivariate model parameters, then assume that your model
specific \code{efficacy()} method receives a samples matrix where the rows
correspond to the sampling index, i.e. the layout is then
\verb{nSamples x dimParameter}.
}
\section{Functions}{
\itemize{
\item \code{efficacy(dose = numeric, model = Effloglog, samples = Samples)}: compute the expected efficacy at a specified dose level,
based on the samples of \code{\link{Effloglog}} model parameters.

\item \code{efficacy(dose = numeric, model = Effloglog, samples = missing)}: compute the expected efficacy at a specified dose level,
based on the \code{\link{Effloglog}} model parameters.
All model parameters (except \code{dose}) should be present in the \code{model} object.

\item \code{efficacy(dose = numeric, model = EffFlexi, samples = Samples)}: compute the expected efficacy at a specified dose level,
based on the samples of \code{\link{EffFlexi}} model parameters. If a given dose in
the \code{dose} vector is from outside of the dose grid range, the \code{NA_real} is
returned for this dose and the warning is thrown.

}}
\examples{
# Obtain the expected efficacy value for a given dose, a given pseudo efficacy
# model (in flexible form for prior) and efficacy samples.

# Empty data (i.e. no observed data), dose grid only.
my_data <- DataDual(doseGrid = seq(25, 300, 25))

my_model <- EffFlexi(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  sigma2W = c(a = 0.1, b = 0.1),
  sigma2betaW = c(a = 20, b = 50),
  rw1 = FALSE,
  data = my_data
)

my_options <- McmcOptions(
  burnin = 100,
  step = 2,
  samples = 200,
  rng_kind = "Mersenne-Twister",
  rng_seed = 94
)

my_samples <- mcmc(data = my_data, model = my_model, options = my_options)

# Efficacy for dose 75.
efficacy(dose = 75, model = my_model, samples = my_samples)

# Obtain the expected efficacy value for a given dose, a given pseudo efficacy
# model (linear log-log efficacy) and no samples.
my_model_ll <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = my_data,
  const = 0
)

efficacy(dose = 75, model = my_model_ll)
}
\seealso{
\code{\link[=dose]{dose()}}, \code{\link[=prob]{prob()}}.
}
