% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_jags.R
\name{h_jags_get_model_inits}
\alias{h_jags_get_model_inits}
\title{Setting Initial Values for \code{JAGS} Model Parameters}
\usage{
h_jags_get_model_inits(model, data)
}
\arguments{
\item{model}{(\code{GeneralModel})\cr an input model.}

\item{data}{(\code{GeneralData})\cr an input data.}
}
\value{
A \code{list} of starting values for parameters required to be initialized
in the MCMC \code{JAGS }sampler.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A simple helper function that prepares an object for \code{inits} argument of
\code{\link[rjags:jags.model]{rjags::jags.model()}}, which is invoked by \code{\link[=mcmc]{mcmc()}} method. The \code{inits}
argument specifies initial values for model parameters.
}
\examples{
# Create some data from the class `Data`.
my_data <- Data(
  x = c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
  y = c(0, 0, 0, 0, 0, 0, 1, 0),
  doseGrid = c(0.1, 0.5, 1.5, 3, 6, seq(from = 10, to = 80, by = 2))
)

# Initialize the CRM model.
my_model <- LogisticLogNormal(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
  ref_dose = 56
)

h_jags_get_model_inits(model = my_model, data = my_data)
}
