% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{CohortSizeMin-class}
\alias{CohortSizeMin-class}
\alias{.CohortSizeMin}
\alias{CohortSizeMin}
\alias{.DefaultCohortSizeMin}
\title{\code{CohortSizeMin}}
\usage{
CohortSizeMin(cohort_sizes)

.DefaultCohortSizeMin()
}
\arguments{
\item{cohort_sizes}{(\code{list})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{CohortSizeMin}} is the class for cohort size that is based on minimum of
multiple cohort size rules. The \code{cohort_sizes} slot stores a set of cohort
size rules, which are again the objects of class \code{\link{CohortSize}}. The minimum
of these individual cohort sizes is taken to give the final cohort size.
}
\section{Slots}{

\describe{
\item{\code{cohort_sizes}}{(\code{list})\cr a list of cohort size rules, i.e. objects
of class \code{\link{CohortSize}}.}
}}

\note{
Typically, end users will not use the \code{.DefaultCohortSizeMin()} function.
}
\examples{
# Rule for cohort of size 1 for doses <30 and cohort of size 3 for doses >=30.
my_size1 <- CohortSizeRange(intervals = c(0, 10), cohort_size = c(1, 3))

# Rule for cohort of size 1 until no DLT were observed and cohort of size 3
# as soon as 1 DLT is observed.
my_size2 <- CohortSizeDLT(intervals = c(0, 1), cohort_size = c(1, 3))

# Cohort size rules of class 'CohortSizeMin' which will then be combined with
# the 'min' operation.
my_size <- CohortSizeMin(cohort_sizes = list(my_size1, my_size2))
}
