% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrmPackClass-methods.R, R/Data-methods.R,
%   R/Simulations-class.R, R/Model-methods.R, R/Rules-methods.R,
%   R/Design-methods.R, R/Samples-methods.R
\name{tidy}
\alias{tidy}
\alias{tidy,CrmPackClass-method}
\alias{tidy-CrmPackClass}
\alias{tidy,GeneralData-method}
\alias{tidy-GeneralData}
\alias{tidy,DataGrouped-method}
\alias{tidy-DataGrouped}
\alias{tidy,DataDA-method}
\alias{tidy-DataDA}
\alias{tidy,DataDual-method}
\alias{tidy-DataDual}
\alias{tidy,DataParts-method}
\alias{tidy-DataParts}
\alias{tidy,DataMixture-method}
\alias{tidy-DataMixture}
\alias{tidy,DataOrdinal-method}
\alias{tidy-DataOrdinal}
\alias{tidy,Simulations-method}
\alias{tidy-Simulations}
\alias{tidy,LogisticIndepBeta-method}
\alias{tidy-LogisticIndepBeta}
\alias{tidy,Effloglog-method}
\alias{tidy-Effloglog}
\alias{tidy,IncrementsMaxToxProb-method}
\alias{tidy-IncrementsMaxToxProb}
\alias{tidy,IncrementsRelative-method}
\alias{tidy-IncrementsRelative}
\alias{tidy,CohortSizeDLT-method}
\alias{tidy-CohortSizeDLT}
\alias{tidy,CohortSizeMin-method}
\alias{tidy-CohortSizeMin}
\alias{tidy,CohortSizeMax-method}
\alias{tidy-CohortSizeMax}
\alias{tidy,CohortSizeRange-method}
\alias{tidy-CohortSizeRange}
\alias{tidy,CohortSizeParts-method}
\alias{tidy-CohortSizeParts}
\alias{tidy,IncrementsMin-method}
\alias{tidy-IncrementsMin}
\alias{tidy,IncrementsRelativeDLT-method}
\alias{tidy-IncrementsRelativeDLT}
\alias{tidy,IncrementsRelativeParts-method}
\alias{tidy-IncrementsRelativeParts}
\alias{tidy,NextBestNCRM-method}
\alias{tidy-NextBestNCRM}
\alias{tidy,NextBestNCRMLoss-method}
\alias{tidy-NextBestNCRMLoss}
\alias{tidy,DualDesign-method}
\alias{tidy-DualDesign}
\alias{tidy,Samples-method}
\alias{tidy-Samples}
\title{Tidying \code{CrmPackClass} objects}
\usage{
tidy(x, ...)

\S4method{tidy}{CrmPackClass}(x, ...)

\S4method{tidy}{GeneralData}(x, ...)

\S4method{tidy}{DataGrouped}(x, ...)

\S4method{tidy}{DataDA}(x, ...)

\S4method{tidy}{DataDual}(x, ...)

\S4method{tidy}{DataParts}(x, ...)

\S4method{tidy}{DataMixture}(x, ...)

\S4method{tidy}{DataOrdinal}(x, ...)

\S4method{tidy}{Simulations}(x, ...)

\S4method{tidy}{LogisticIndepBeta}(x, ...)

\S4method{tidy}{Effloglog}(x, ...)

\S4method{tidy}{IncrementsMaxToxProb}(x, ...)

\S4method{tidy}{IncrementsRelative}(x, ...)

\S4method{tidy}{CohortSizeDLT}(x, ...)

\S4method{tidy}{CohortSizeMin}(x, ...)

\S4method{tidy}{CohortSizeMax}(x, ...)

\S4method{tidy}{CohortSizeRange}(x, ...)

\S4method{tidy}{CohortSizeParts}(x, ...)

\S4method{tidy}{IncrementsMin}(x, ...)

\S4method{tidy}{IncrementsRelative}(x, ...)

\S4method{tidy}{IncrementsRelativeDLT}(x, ...)

\S4method{tidy}{IncrementsRelativeParts}(x, ...)

\S4method{tidy}{NextBestNCRM}(x, ...)

\S4method{tidy}{NextBestNCRMLoss}(x, ...)

\S4method{tidy}{DualDesign}(x, ...)

\S4method{tidy}{Samples}(x, ...)
}
\arguments{
\item{x}{(\code{CrmPackClass})\cr the object to be tidied.}

\item{...}{potentially used by class-specific methods.}
}
\value{
A (list of) tibble(s) representing the object in tidy form.

The \code{\link[tibble:tibble]{tibble::tibble}} object.

The \code{\link[tibble:tibble]{tibble::tibble}} object.

The \code{\link[tibble:tibble]{tibble::tibble}} object.

The \code{\link[tibble:tibble]{tibble::tibble}} object.

The \code{\link[tibble:tibble]{tibble::tibble}} object.

The \code{\link[tibble:tibble]{tibble::tibble}} object.

The \code{\link[tibble:tibble]{tibble::tibble}} object.

The \code{\link{list}} of \code{\link[tibble:tibble]{tibble::tibble}} objects.

The \code{\link{list}} of \code{\link[tibble:tibble]{tibble::tibble}} objects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

In the spirit of the \code{broom} package, provide a method to convert a
\code{CrmPackClass} object to a (list of) tibbles.

Following the principles of the \code{broom} package, convert a \code{CrmPackClass}
object to a (list of) tibbles.  This is a basic, default representation.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{GeneralData}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{DataGrouped}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{DataDA}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{DataDual}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{DataParts}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{DataMixture}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{DataOrdinal}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{LogisticIndepBeta}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that tidies a \code{\link{Effloglog}} object.
}
\section{Usage Notes}{

The prior observations are indicated by a \code{Cohort} value of \code{0} in the returned
\code{tibble}.


}

\examples{
CohortSizeConst(3) \%>\% tidy()
.DefaultData() \%>\% tidy()
.DefaultDataOrdinal() \%>\% tidy()
.DefaultDataGrouped() \%>\% tidy()
.DefaultDataDA() \%>\% tidy()
.DefaultData() \%>\% tidy()
.DefaultDataOrdinal() \%>\% tidy()
.DefaultDataGrouped() \%>\% tidy()
.DefaultDataDA() \%>\% tidy()
.DefaultData() \%>\% tidy()
.DefaultDataOrdinal() \%>\% tidy()
.DefaultDataGrouped() \%>\% tidy()
.DefaultDataDA() \%>\% tidy()
.DefaultData() \%>\% tidy()
.DefaultDataOrdinal() \%>\% tidy()
.DefaultDataGrouped() \%>\% tidy()
.DefaultDataDA() \%>\% tidy()
.DefaultData() \%>\% tidy()
.DefaultDataOrdinal() \%>\% tidy()
.DefaultDataGrouped() \%>\% tidy()
.DefaultDataDA() \%>\% tidy()
.DefaultData() \%>\% tidy()
.DefaultDataOrdinal() \%>\% tidy()
.DefaultDataGrouped() \%>\% tidy()
.DefaultDataDA() \%>\% tidy()
.DefaultData() \%>\% tidy()
.DefaultDataOrdinal() \%>\% tidy()
.DefaultDataGrouped() \%>\% tidy()
.DefaultDataDA() \%>\% tidy()
.DefaultSimulations() \%>\% tidy()
.DefaultLogisticIndepBeta() \%>\% tidy()
.DefaultEffloglog() \%>\% tidy()
IncrementsMaxToxProb(prob = c("DLAE" = 0.2, "CRS" = 0.05)) \%>\% tidy()
CohortSizeRange(intervals = c(0, 20), cohort_size = c(1, 3)) \%>\% tidy()
.DefaultCohortSizeDLT() \%>\% tidy()
.DefaultCohortSizeMin() \%>\% tidy()
.DefaultCohortSizeMax() \%>\% tidy()
.DefaultCohortSizeRange() \%>\% tidy()
CohortSizeParts(cohort_sizes = c(1, 3)) \%>\% tidy()
.DefaultIncrementsMin() \%>\% tidy()
CohortSizeRange(intervals = c(0, 20), cohort_size = c(1, 3)) \%>\% tidy()
x <- .DefaultIncrementsRelativeDLT()
x \%>\% tidy()
.DefaultIncrementsRelativeParts() \%>\% tidy()
NextBestNCRM(
  target = c(0.2, 0.35),
  overdose = c(0.35, 1),
  max_overdose_prob = 0.25
) \%>\%
  tidy()
.DefaultNextBestNCRMLoss() \%>\% tidy()
.DefaultDualDesign() \%>\% tidy()
options <- McmcOptions(
  burnin = 100,
  step = 1,
  samples = 2000
)

emptydata <- Data(doseGrid = c(1, 3, 5, 10, 15, 20, 25, 40, 50, 80, 100))

model <- LogisticLogNormal(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
  ref_dose = 56
)

samples <- mcmc(emptydata, model, options)
samples \%>\% tidy()
}
\keyword{methods}
