% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-validity.R
\name{v_pseudo_simulations}
\alias{v_pseudo_simulations}
\alias{v_pseudo_dual_simulations}
\alias{v_pseudo_dual_flex_simulations}
\title{Internal Helper Functions for Validation of \code{\link{PseudoSimulations}} Objects}
\usage{
v_pseudo_simulations(object)

v_pseudo_dual_simulations(object)

v_pseudo_dual_flex_simulations(object)
}
\arguments{
\item{object}{(\code{PseudoSimulations})\cr object to validate.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are only used internally to validate the format of an input
\code{\link{PseudoSimulations}} or inherited classes and therefore not exported.
}
\section{Functions}{
\itemize{
\item \code{v_pseudo_simulations()}: validates that the \code{\link{PseudoSimulations}} object
contains valid \code{fit}, \code{FinalTDtargetEndOfTrialEstimates} ,
\code{FinalTDtargetDuringTrialAtDoseGrid},\code{FinalTDtargetEndOfTrialAtDoseGrid} ,
\code{FinalTDEOTCIs}, \code{FinalTDEOTRatios}, \code{FinalCIs}, \code{FinalRatios},
object and valid \code{stopReasons} simulations.

\item \code{v_pseudo_dual_simulations()}: validates that the \code{\link{PseudoDualSimulations}} object
contains valid \code{fit_eff}, \code{final_gstar_estimates} , \code{final_gstar_at_dose_grid},
\code{final_gstar_cis} , \code{final_gstar_ratios}, \code{final_optimal_dose}, \code{final_optimal_dose_at_dose_grid}
object and valid \code{sigma2_est} simulations.

\item \code{v_pseudo_dual_flex_simulations()}: validates that the \code{\link{PseudoDualFlexiSimulations}}
object contains valid \code{sigma2_beta_w_est} vector of the final posterior mean
sigma2betaW estimates.\code{FinalGstarEstimates} , \code{FinalGstarAtDoseGrid},

}}
