% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-class.R
\docType{class}
\name{DualResponsesDesign-class}
\alias{DualResponsesDesign-class}
\alias{.DualResponsesDesign}
\alias{DualResponsesDesign}
\alias{.DefaultDualResponsesDesign}
\title{\code{DualResponsesDesign.R}}
\usage{
DualResponsesDesign(eff_model, data, ...)

.DefaultDualResponsesDesign()
}
\arguments{
\item{eff_model}{(\code{ModelEff})\cr see slot definition.}

\item{data}{(\code{DataDual})\cr see slot definition.}

\item{...}{
  Arguments passed on to \code{\link[=TDDesign]{TDDesign}}
  \describe{
    \item{\code{model}}{(\code{ModelTox})\cr see slot definition.}
    \item{\code{stopping}}{(\code{Stopping})\cr see slot definition.}
    \item{\code{increments}}{(\code{Increments})\cr see slot definition.}
    \item{\code{pl_cohort_size}}{(\code{CohortSize})\cr see slot definition.}
  }}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is a class of design based on DLE responses using the \code{\link{LogisticIndepBeta}} model
without DLE and efficacy samples. It contains all slots from the
\code{\link{RuleDesign}} and \code{\link{TDsamplesDesign}} classes.
}
\section{Slots}{

\describe{
\item{\code{data}}{(\code{DataDual})\cr the data set.}

\item{\code{eff_model}}{(\code{ModelEff})\cr the pseudo efficacy model to be used.}
}}

\note{
Typically, end users will not use the \code{.DefaultDualResponsesDesign()} function.
}
\examples{
empty_data <- DataDual(doseGrid = seq(25, 300, 25))

tox_model <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = empty_data
)

eff_model <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = empty_data
)

my_next_best <- NextBestMaxGain(
  prob_target_drt = 0.35,
  prob_target_eot = 0.3
)

my_increments <- IncrementsRelative(
  intervals = c(25, 300),
  increments = c(2, 2)
)

my_size <- CohortSizeConst(size = 3)
my_stopping <- StoppingMinPatients(nPatients = 36) | StoppingMissingDose()

design <- DualResponsesDesign(
  nextBest = my_next_best,
  cohort_size = my_size,
  startingDose = 25,
  model = tox_model,
  eff_model = eff_model,
  data = empty_data,
  stopping = my_stopping,
  increments = my_increments
)
}
