% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_all_equivalent}
\alias{h_all_equivalent}
\title{Comparison with Numerical Tolerance and Without Name Comparison}
\usage{
h_all_equivalent(target, current, tolerance = 1e-10)
}
\arguments{
\item{target}{(\code{numeric})\cr target values.}

\item{current}{(\code{numeric})\cr current values.}

\item{tolerance}{(\code{number}) relative differences smaller than this are not
reported.}
}
\value{
\code{TRUE} when \code{target} and \code{current} do not differ
up to desired tolerance and without looking at names or other attributes,
\code{FALSE} otherwise.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This helper function ensures a default tolerance level equal to \code{1e-10},
and ignores names and other attributes.
In contrast to \code{\link[=all.equal]{all.equal()}}, it always returns a logical type object.
}
