% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_vcov.R
\name{pooled_vcov}
\alias{pooled_vcov}
\title{Variance-covariance of Mean-Group (MG) averages}
\usage{
pooled_vcov(beta_i, weights = NULL, pairwise = TRUE)
}
\arguments{
\item{beta_i}{Numeric matrix of unit-specific coefficients (\eqn{N x K});
rows = units, columns = coefficients. May contain \code{NA}s.}

\item{weights}{Optional numeric vector of length N with nonnegative weights
summing to 1. If \code{NULL}, uses equal weights.}

\item{pairwise}{Logical; use pairwise-complete covariances across units (default \code{TRUE}).}
}
\value{
A \code{K x K} covariance matrix for the MG mean, with
\code{dimnames} inherited from \code{colnames(beta_i)}.
}
\description{
Computes the covariance matrix of the MG estimator \eqn{\bar{\beta} = N^{-1} \sum_i \hat\beta_i},
using the cross-sectional covariance of unit-specific slopes and dividing by the
effective sample sizes per coefficient (handles missing entries per unit).
}
\details{
For equal weights, diagonal entries coincide with \eqn{\widehat{\mathrm{Var}}(\hat\beta_{ij}) / N_{\text{eff},j}}.
Off-diagonals are scaled analogously using pairwise effective N. If \code{weights} are
provided, computes \eqn{\mathrm{Var}(\sum_i w_i \hat\beta_i)} using a weighted covariance.
}
\keyword{internal}
