% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.ct.R
\name{procrustes.plot.mds}
\alias{procrustes.plot.mds}
\title{Plot of classical and continuous-time principal coordinates}
\usage{
procrustes.plot.mds(
  obj,
  points,
  npoints = 500,
  cols = viridis(50),
  procoord = 1:2,
  plotcoord = 1:2,
  linewidth = 1.3,
  ltitle = "time",
  title = "",
  samescale = FALSE,
  cex.legend = 1,
  GOF.method = 1,
  digits = 1,
  xlim = NULL,
  ylim = NULL,
  size.axis.title = 11,
  size.axis.text = 11,
  size.ltitle = 11,
  size.ltext = 11,
  coord_fixed = TRUE,
  xlab = NULL,
  ylab = NULL,
  colourbar = TRUE,
  ...
)
}
\arguments{
\item{obj}{an object of class "\code{\link{mds.ct}}"}

\item{points}{matrix of classical principal coordinates, 
e.g. as produced by \code{\link{cmdscale}}}

\item{npoints}{number of time points (equally spaced along the range of times) 
at which to plot the coordinates}

\item{cols}{color scheme; viridis(50) by default}

\item{procoord}{coordinates to which Procrustes transformation should be applied}

\item{plotcoord}{which coordinates to plot}

\item{linewidth}{line width for the principal coordinate curve}

\item{ltitle}{legend title}

\item{title}{title of the graph}

\item{samescale}{logical: Should the x- and y-axes have the same range?}

\item{cex.legend}{scaling factor for legend key}

\item{GOF.method}{method to use for computing percent dissimilarity explained
(see argument \code{GOF} of \code{\link{cmdscale}})}

\item{digits}{number of digits to display for percent dissimilarity explained}

\item{xlim, ylim}{x- and y-limits. Ignored if \code{samescale==TRUE}.}

\item{size.axis.title}{size for axis titles}

\item{size.axis.text}{size for axis text}

\item{size.ltitle}{size for color legend title}

\item{size.ltext}{size for color legend text}

\item{coord_fixed}{logical: Should aspect ratio be fixed to 1?}

\item{xlab, ylab}{x- and y-labels. If these are NULL, the principal coordinate numbers 
and the percent dissimilarity explained are used as the axis labels.}

\item{colourbar}{logical: Should a color bar (legend) be included?}

\item{...}{arguments passed to \code{\link[ggplot2]{labs}}}
}
\value{
None; a plot is generated
}
\description{
This function plots two continuous-time principal coordinates along with the 
corresponding classical principal coordinates, where the latter is aligned with
the former by Procrustes transformation
}
\examples{
# see example for mds.ct

}
\seealso{
\code{\link{procrustes.mds.ct}}
}
\author{
Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
