% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_matrix_smart}
\alias{create_matrix_smart}
\title{Create a matrix for lower and upper}
\usage{
create_matrix_smart(input, conds, prm_labels = NULL)
}
\arguments{
\item{input}{either a list or a vector of numeric values}

\item{conds}{a character string, conceptually representing the
conditions of a model}

\item{prm_labels}{a character string with parameter labels. Used as a fall
back when the default_values are not labeled (see details)}
}
\value{
a matrix indicating either the upper or lower end of a parameter
space. There will be as many rows as \code{conds} implies. The number of columns
depend on \code{input} (matching its length if it is a vector, or matching the
length of the entry "default_values" if it is a list). If \code{input} is
\code{NULL}, then \code{NULL} is returned.
}
\description{
Outsourced, deep inside the package function to avoid large nesting
}
\details{
The goal of this function is to build up a matrix, serving as the upper or
lower end of a parameter space (relevant when simulating data). The function
gets called by \code{\link[=get_parameters_smart]{get_parameters_smart()}}.

It assumes the following: \code{input} is either a list or a numeric vector.
\itemize{
\item The easiest case is when it is a numeric vector. In this case, the
function builds a matrix with as many rows as entries in \code{conds}. The
rows will also be labeled according to \code{conds}. The column names are
either the names specified with the numeric vector, or the labels specified
in \code{prm_labels}
\item The less intuitive case is when \code{input} is a list. In this case, the list
requires an entry called "default_values" which specifies the named or plain
numeric vector as above. If the list only contains this entry, then the
behavior is as if \code{input} was already a numeric vector. However, the \code{input}
list can also have entries labeled as specific conditions, which contain
named (!) numeric vectors with parameter labels. This will modify the
value for the upper/lower parameter space with respect to the specified
parameters in the respective condition.#'
}
}
\seealso{
\code{\link[=simulate_data]{simulate_data()}}, \code{\link[=simulate_values]{simulate_values()}}
}
\keyword{internal}
