% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{solver<-}
\alias{solver<-}
\alias{solver<-.drift_dm}
\alias{solver}
\alias{solver.drift_dm}
\alias{solver.fits_ids_dm}
\alias{solver.fits_agg_dm}
\title{The Solver for Deriving Model Predictions}
\usage{
solver(object, ...) <- value

\method{solver}{drift_dm}(object, ..., eval_model = FALSE) <- value

solver(object, ...)

\method{solver}{drift_dm}(object, ...)

\method{solver}{fits_ids_dm}(object, ...)

\method{solver}{fits_agg_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm}, \code{fits_ids_dm}, or
\code{fits_agg_dm} (see \code{\link[=estimate_dm]{estimate_dm()}}).}

\item{...}{additional arguments (i.e., \code{eval_model}).}

\item{value}{a single character string, providing the new "solver" (i.e.,
approach to derive the first passage time; see \code{\link[=drift_dm]{drift_dm()}}).}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the solver (see \link{re_evaluate_model}). Default is
\code{FALSE}.}
}
\value{
For \code{solve()} the string \code{solver} (see \code{\link[=drift_dm]{drift_dm()}}).

For \verb{solver<-()} the updated \link{drift_dm} object.
}
\description{
Functions to get or set the "solver" of an object. The "solver" controls
the method for deriving the model's first passage time (i.e., its predicted
PDFs).
}
\details{
\code{solver()} is a generic accessor function, and \verb{solver<-()} is a
generic replacement function. The default methods get and set the "solver".

The "solver" indicates the approach with which the PDFs of a model are
calculated. Supported options are "kfe" and "im_zero" (method based on the
Kolmogorov-Forward-Equation or on integral equations, respectively). Note
that "im_zero" is only supported for models that assume a fixed starting
point from 0.
}
\note{
There is only a replacement function for \link{drift_dm} objects. This is
because replacing the approach for deriving PDFs after the model has been
fitted (i.e., for a \code{fits_ids_dm} object) doesn't make sense.
}
\examples{
# get some default model to demonstrate the solver() functions
my_model <- ratcliff_dm()
solver(my_model)
# change to the integral approach
solver(my_model) <- "im_zero"
solver(my_model)

# accessor method also available for fits_ids_dm objects
# (see estimate_model_ids)
# get an exemplary fits_ids_dm object
fits <- get_example_fits("fits_ids_dm")
solver(fits)

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
