% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatetimeTrendPlots.R
\name{GetAccuracyOverTimePlotsMetadata}
\alias{GetAccuracyOverTimePlotsMetadata}
\title{Retrieve Accuracy over Time plots metadata for a model.}
\usage{
GetAccuracyOverTimePlotsMetadata(model, forecastDistance = NULL)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{forecastDistance}{integer. Optional. Forecast distance to retrieve the metadata for.
If not specified, the first forecast distance for this project will be used.
Only available for time series projects.}
}
\value{
list with the following components:
\itemize{
  \item forecastDistance. integer or NULL:
        The forecast distance for which the metadata was retrieved. NULL for OTV projects.
  \item resolutions. list: A list of \code{DatetimeTrendPlotsResolutions},
        which represents available time resolutions for which plots can be retrieved.
  \item backtestStatuses. data.frame: Each row represents a status for the backtest
        \code{SourceType}. The row index corresponds to the backtest index via the relation
        \code{rowIndex <- backtestIndex + 1}. Status should be one of
        \code{DatetimeTrendPlotsStatuses}
  \item backtestMetadata. data.frame: Each row represents a metadata for the backtest
        \code{SourceType} start and end date. The row index corresponds to the
        backtest index via the relation \code{rowIndex <- backtestIndex + 1}.
        Each cell contains a POSIXct timestamp for start date (inclusive)
        and end date (exclusive) if the correspoding source type
        for the backtest is computed, and NA otherwise.
  \item holdoutStatuses. list: Contains statuses for holdout.
  \itemize{
    \item training. character: Status, one of \code{DatetimeTrendPlotsStatuses}
    \item validation. character: Status, one of \code{DatetimeTrendPlotsStatuses}
  }
  \item holdoutMetadata. list. Contains metadata for holdout.
  \itemize{
    \item training. list. Contains start and end date for holdout training.
    \item validation. list. Contains start and end date for holdout validation.
      \itemize{
        \item startDate. POSIXct or NA:
              The datetime of the start of the holdout training/validation (inclusive).
              NA if the data is not computed.
        \item endDate. POSIXct or NA:
              The datetime of the end of the holdout training/validation (exclusive).
              NA if the data is not computed.
        }
  }
}
}
\description{
Retrieve Accuracy over Time plots metadata for a model.
}
\examples{
\dontrun{
projectId <- "59a5af20c80891534e3c2bde"
modelId <- "5996f820af07fc605e81ead4"
model <- GetModel(projectId, modelId)
GetAccuracyOverTimePlotsMetadata(model)
}
}
