% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{RequestPredictionExplanationsInitialization}
\alias{RequestPredictionExplanationsInitialization}
\title{Request prediction explanations initialization for specified model}
\usage{
RequestPredictionExplanationsInitialization(model)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}
}
\value{
job Id
}
\description{
Prediction explanations initializations are a prerequisite for computing prediction
explanations, and include a sample of what the computed prediction explanations for a
prediction dataset would look like.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  RequestPredictionExplanationsInitialization(model)
}
}
