% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{ScoreBacktests}
\alias{ScoreBacktests}
\title{Compute the scores for all available backtests.}
\usage{
ScoreBacktests(model, wait = FALSE)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{wait}{logical. If TRUE, wait until job completion.}
}
\value{
job ID of pending job if \code{wait} is FALSE. Use \code{WaitForJobToComplete}
  to await job completion. If \code{wait} is TRUE, will wait until completion and return
  \code{NULL}. Upon completion, all available backtests will have scores computed.
}
\description{
Some backtests may be unavailable if the model is trained into their validation data.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  ScoreBacktests(model)
}
}
