% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_logical.R
\name{as_logical}
\alias{as_logical}
\alias{as_logical.haven_labelled_defined}
\title{Coerce a defined vector to logical}
\usage{
as_logical(x, ...)

\method{as_logical}{haven_labelled_defined}(x, strip_attributes = TRUE, ...)
}
\arguments{
\item{x}{A vector created with \code{\link[=defined]{defined()}}.}

\item{...}{Additional arguments (currently unused).}

\item{strip_attributes}{Logical; should semantic metadata attributes
(such as \code{label}, \code{unit}, \code{definition}, and
\code{namespace}) be removed from the returned vector?
Defaults to \code{FALSE}.}
}
\value{
A logical vector. If \code{strip_attributes = FALSE}, any semantic
metadata attached to \code{x} will be carried over to the returned vector.
}
\description{
Coerces a \code{\link{haven_labelled_defined}} vector created with \code{\link[=defined]{defined()}}
into a base R logical vector.

This function is the recommended, semantic-aware interface for converting
defined logical vectors. It preserves the underlying logical values and,
unless otherwise requested, retains the semantic metadata attached to the
variable.
}
\details{
Use \code{strip_attributes = TRUE} when flattening or preparing data for
external pipelines, but keep the default when working with defined
vectors directly.

Users may also call base R's \code{\link[=as.logical]{as.logical()}}, which will dispatch to this
method automatically via S3. However, \code{as_logical()} is preferred because
it makes the semantics explicit and supports the \code{strip_attributes}
argument.
}
\examples{
# Basic usage
flg <- defined(c(TRUE, FALSE, TRUE), label = "Flag")
as_logical(flg)

# Metadata preserved by default
attr(as_logical(flg), "label")

# Stripping metadata
as_logical(flg, strip_attributes = TRUE)

# Base R coercion also works (via S3 method dispatch)
as.logical(flg)

}
\seealso{
\code{\link[=as_numeric]{as_numeric()}}, \code{\link[=as_character]{as_character()}},
\code{\link[=as.Date]{as.Date()}}, \code{\link[=as.POSIXct]{as.POSIXct()}},
\code{\link[=defined]{defined()}}
}
